% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/T_and_F_symbol_linter.R
\name{T_and_F_symbol_linter}
\alias{T_and_F_symbol_linter}
\title{\code{T} and \code{F} symbol linter}
\usage{
T_and_F_symbol_linter()
}
\description{
Although they can be synonyms, avoid the symbols \code{T} and \code{F}, and use \code{TRUE} and \code{FALSE}, respectively, instead.
\code{T} and \code{F} are not reserved keywords and can be assigned to any other values.
}
\examples{
# will produce lints
lint(
  text = "x <- T; y <- F",
  linters = T_and_F_symbol_linter()
)

lint(
  text = "T = 1.2; F = 2.4",
  linters = T_and_F_symbol_linter()
)

# okay
lint(
  text = "x <- c(TRUE, FALSE)",
  linters = T_and_F_symbol_linter()
)

lint(
  text = "t = 1.2; f = 2.4",
  linters = T_and_F_symbol_linter()
)

}
\seealso{
\itemize{
\item \link{linters} for a complete list of linters available in lintr.
\item \url{https://style.tidyverse.org/syntax.html#logical-vectors}
}
}
\section{Tags}{
\link[=best_practices_linters]{best_practices}, \link[=consistency_linters]{consistency}, \link[=default_linters]{default}, \link[=readability_linters]{readability}, \link[=robustness_linters]{robustness}, \link[=style_linters]{style}
}
