% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{protectWorkbook}
\alias{protectWorkbook}
\title{Protect a workbook from modifications}
\usage{
protectWorkbook(
  wb,
  protect = TRUE,
  password = NULL,
  lockStructure = FALSE,
  lockWindows = FALSE,
  type = 1L
)
}
\arguments{
\item{wb}{A workbook object}

\item{protect}{Whether to protect or unprotect the sheet (default=TRUE)}

\item{password}{(optional) password required to unprotect the workbook}

\item{lockStructure}{Whether the workbook structure should be locked}

\item{lockWindows}{Whether the window position of the spreadsheet should be locked}

\item{type}{Lock type, default 1. From the xml documentation: 1 - Document is password protected. 2 - Document is recommended to be opened as read-only. 4 - Document is enforced to be opened as read-only. 8 - Document is locked for annotation.}
}
\description{
Protect or unprotect a workbook from modifications by the user in the graphical user interface. Replaces an existing protection.
}
\examples{
wb <- createWorkbook()
addWorksheet(wb, "S1")
protectWorkbook(wb, protect = TRUE, password = "Password", lockStructure = TRUE)
\dontrun{
saveWorkbook(wb, "WorkBook_Protection.xlsx", overwrite = TRUE)
}
# Remove the protection
protectWorkbook(wb, protect = FALSE)
\dontrun{
saveWorkbook(wb, "WorkBook_Protection_unprotected.xlsx", overwrite = TRUE)
}
}
\author{
Reinhold Kainhofer
}
