% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.nexus.partitions.R
\name{read.nexus.partitions}
\alias{read.nexus.partitions}
\title{Function to import partitioned data from nexus files}
\usage{
read.nexus.partitions(file, return = "list", ...)
}
\arguments{
\item{file}{a file name.}

\item{return}{either returns a list where each element is a 'phyDat' object
or an object of class 'multiphyDat'}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
a list where each element is a 'phyDat' object or an object of class
'multiphyDat'.
}
\description{
\code{read.nexus.partitions} reads in sequences in NEXUS format and splits
the data according to the charsets given in the SETS block.
}
\examples{
tree <- rtree(10)
dat <- simSeq(tree, l=24)
fcat <- function(..., file = zz) cat(..., file=file, sep="", append=TRUE)
zz <- tempfile(pattern="file", tmpdir=tempdir(), fileext=".nex")
write.phyDat(dat, file=zz, format="nexus")
fcat("BEGIN SETS;\n")
fcat("  Charset codon1 = 1-12/3;\n")
fcat("  Charset codon2 = 2-12/3;\n")
fcat("  Charset codon3 = 3-12/3;\n")
fcat("  Charset range = 16-18;\n")
fcat("  Charset range2 = 13-15 19-21;\n")
fcat("  Charset singles = 22 23 24;\n")
fcat("END;\n")

tmp <- read.nexus.partitions(zz)
tmp
unlink(zz)
}
\seealso{
\code{\link[ape]{read.nexus.data}}, \code{\link{read.phyDat}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
