% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rc.R
\name{rc_submit}
\alias{rc_submit}
\title{Submit a package to the R Consortium runners}
\usage{
rc_submit(path = ".", platforms = NULL, email = NULL, confirmation = NULL)
}
\arguments{
\item{path}{Path to package file or package directory.}

\item{platforms}{Platforms to checks. See \code{\link[=rhub_platforms]{rhub_platforms()}} for a
current list. If not specified, then you can select the platforms
interactively. Must be specified in non-interactive sessions.}

\item{email}{Email address. You must have a token on the local machhine,
that corresponds to the email address, see \code{\link[=rc_new_token]{rc_new_token()}}.
If not specified (or \code{NULL}) then the email address of the package
maintainer is used.}

\item{confirmation}{You must set this to \code{TRUE} to submit a package
from a non-interactive session.}
}
\value{
A list with data about the submission, invisibly.
Currently it has:
\itemize{
\item \code{result}: Should be the string \code{"OK"}.
\item \code{repo_url}: URL to the repository.
\item \code{actions_url}: URL to the builds inside the repository.
\item \code{id}: Build id. This is a string with a randomly generated id.
\item \code{name}: Build name, this is a string, the concatenation of the
build platforms.
}

More fields might be added later.
}
\description{
Submit a package to the R Consortium runners
}
\seealso{
\code{\link[=rhub_platforms]{rhub_platforms()}} for a list of supported platforms.

Other RC runners API: 
\code{\link{rc_list_local_tokens}()},
\code{\link{rc_list_repos}()},
\code{\link{rc_new_token}()}
}
\concept{RC runners API}
