% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compatibility.R, R/property.R
\name{prop}
\alias{prop}
\alias{@}
\alias{prop<-}
\alias{@.S7_object}
\title{Get/set a property}
\usage{
prop(object, name)

prop(object, name, check = TRUE) <- value

object@name
}
\arguments{
\item{object}{An object from a S7 class}

\item{name}{The name of the parameter as a character. Partial matching
is not performed.}

\item{check}{If \code{TRUE}, check that \code{value} is of the correct type and run
\code{\link[=validate]{validate()}} on the object before returning.}

\item{value}{A new value for the property. The object is automatically
checked for validity after the replacement is done.}
}
\value{
\code{prop()} and \code{@} return the value of the property.
\verb{prop<-()} and \verb{@<-} are called for their side-effects and return
the modified object, invisibly.
}
\description{
\itemize{
\item \code{prop(x, "name")} / \code{prop@name} get the value of the a property,
erroring if it the property doesn't exist.
\item \code{prop(x, "name") <- value} / \code{prop@name <- value} set the value of
a property.
}
}
\examples{
Horse <- new_class("Horse", properties = list(
  name = class_character,
  colour = class_character,
  height = class_numeric
))
lexington <- Horse(colour = "bay", height = 15, name = "Lex")
lexington@colour
prop(lexington, "colour")

lexington@height <- 14
prop(lexington, "height") <- 15
}
