% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDiagnosis.R
\name{kurtosis}
\alias{kurtosis}
\title{Finding excessive kurtosis}
\usage{
kurtosis(object, population = FALSE)
}
\arguments{
\item{object}{A vector used to find a excessive kurtosis}

\item{population}{\code{TRUE} to compute the parameter formula. \code{FALSE}
to compute the sample statistic formula.}
}
\value{
A value of an excessive kurtosis with a test statistic if the
population is specified as \code{FALSE}
}
\description{
Finding excessive kurtosis (\eqn{g_{2}}) of an object
}
\details{
The excessive kurtosis computed by default is \eqn{g_{2}}, the fourth
standardized moment of the empirical distribution of \code{object}.
The population parameter excessive kurtosis \eqn{\gamma_{2}} formula is

\deqn{\gamma_{2} = \frac{\mu_{4}}{\mu^{2}_{2}} - 3,}

where \eqn{\mu_{i}} denotes the \eqn{i} order central moment.

The excessive kurtosis formula for sample statistic \eqn{g_{2}} is

\deqn{g_{2} = \frac{k_{4}}{k^{2}_{2}} - 3,}

where \eqn{k_{i}} are the \eqn{i} order \emph{k}-statistic.

The standard error of the excessive kurtosis is

\deqn{Var(\hat{g}_{2}) = \frac{24}{N}}

where \eqn{N} is the sample size.
}
\examples{

kurtosis(1:5)

}
\references{
Weisstein, Eric W. (n.d.). \emph{Kurtosis.} Retrieved from
\emph{MathWorld}--A Wolfram Web Resource:
\url{http://mathworld.wolfram.com/Kurtosis.html}
}
\seealso{
\itemize{
\item \code{\link[=skew]{skew()}} Find the univariate skewness of a variable
\item \code{\link[=mardiaSkew]{mardiaSkew()}} Find the Mardia's multivariate
skewness of a set of variables
\item \code{\link[=mardiaKurtosis]{mardiaKurtosis()}} Find the Mardia's multivariate kurtosis
of a set of variables
}
}
\author{
Sunthud Pornprasertmanit (\email{psunthud@gmail.com})
}
