% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string.R
\name{html_tag}
\alias{html_tag}
\alias{html_value}
\alias{html_escape}
\alias{html_view}
\title{Tools for HTML tags}
\usage{
html_tag(.name, .content = NULL, .attrs = NULL, ...)

html_value(x)

html_escape(x, attr = FALSE)

html_view(x, ...)
}
\arguments{
\item{.name}{The tag name.}

\item{.content}{The content between opening and closing tags. Ignored for
void tags such as \verb{<img>}. Special characters such as \code{&}, \code{<}, and \code{>}
will be escaped unless the value was generated from \code{\link[=html_value]{html_value()}}. The
content can be either a character vector or a list. If it is a list, it may
contain both normal text and HTML content.}

\item{.attrs}{A named list of attributes.}

\item{...}{For \code{html_tag()}, named arguments as an alternative way to provide
attributes. For \code{html_view()}, other arguments to be passed to \code{\link[=new_app]{new_app()}}.}

\item{x}{A character vector to be treated as raw HTML content for
\code{html_value()}, escaped for \code{html_escape()}, and viewed for \code{html_view()}.}

\item{attr}{Whether to escape \verb{"}, \verb{\\r}, and \verb{\\n} (which should be escaped
for tag attributes).}
}
\value{
A character string.
}
\description{
Given a tag name, generate an HTML tag with optional attributes and content.
\code{\link[=html_tag]{html_tag()}} can be viewed as a simplified version of \code{htmltools::tags},
\code{\link[=html_value]{html_value()}} adds classes on the value so that it will be treated as raw
HTML (not escaped by \code{html_tag()}), \code{\link[=html_escape]{html_escape()}} escapes special
characters in HTML, and \code{html_view()} launches a browser or viewer to view
the HTML content.
}
\examples{
xfun::html_tag("a", "<R Project>", href = "https://www.r-project.org", target = "_blank")
xfun::html_tag("br")
xfun::html_tag("a", xfun::html_tag("strong", "R Project"), href = "#")
xfun::html_tag("a", list("<text>", xfun::html_tag("b", "R Project")), href = "#")
xfun::html_escape("\" quotes \" & brackets < >")
xfun::html_escape("\" & < > \r \n", attr = TRUE)
}
