#![doc = " fiat-crypto output postprocessed by fiat-constify: https://github.com/rustcrypto/utils"]
#![doc = " Autogenerated: 'src/ExtractionOCaml/word_by_word_montgomery' --lang Rust --inline p384 64 '2^384 - 2^128 - 2^96 + 2^32 - 1' mul square add sub opp from_montgomery to_montgomery nonzero selectznz to_bytes from_bytes one msat divstep divstep_precomp"]
#![doc = " curve description: p384"]
#![doc = " machine_wordsize = 64 (from \"64\")"]
#![doc = " requested operations: mul, square, add, sub, opp, from_montgomery, to_montgomery, nonzero, selectznz, to_bytes, from_bytes, one, msat, divstep, divstep_precomp"]
#![doc = " m = 0xfffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffffeffffffff0000000000000000ffffffff (from \"2^384 - 2^128 - 2^96 + 2^32 - 1\")"]
#![doc = ""]
#![doc = " NOTE: In addition to the bounds specified above each function, all"]
#![doc = "   functions synthesized for this Montgomery arithmetic require the"]
#![doc = "   input to be strictly less than the prime modulus (m), and also"]
#![doc = "   require the input to be in the unique saturated representation."]
#![doc = "   All functions also ensure that these two properties are true of"]
#![doc = "   return values."]
#![doc = ""]
#![doc = " Computed values:"]
#![doc = "   eval z = z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) + (z[4] << 256) + (z[5] << 0x140)"]
#![doc = "   bytes_eval z = z[0] + (z[1] << 8) + (z[2] << 16) + (z[3] << 24) + (z[4] << 32) + (z[5] << 40) + (z[6] << 48) + (z[7] << 56) + (z[8] << 64) + (z[9] << 72) + (z[10] << 80) + (z[11] << 88) + (z[12] << 96) + (z[13] << 104) + (z[14] << 112) + (z[15] << 120) + (z[16] << 128) + (z[17] << 136) + (z[18] << 144) + (z[19] << 152) + (z[20] << 160) + (z[21] << 168) + (z[22] << 176) + (z[23] << 184) + (z[24] << 192) + (z[25] << 200) + (z[26] << 208) + (z[27] << 216) + (z[28] << 224) + (z[29] << 232) + (z[30] << 240) + (z[31] << 248) + (z[32] << 256) + (z[33] << 0x108) + (z[34] << 0x110) + (z[35] << 0x118) + (z[36] << 0x120) + (z[37] << 0x128) + (z[38] << 0x130) + (z[39] << 0x138) + (z[40] << 0x140) + (z[41] << 0x148) + (z[42] << 0x150) + (z[43] << 0x158) + (z[44] << 0x160) + (z[45] << 0x168) + (z[46] << 0x170) + (z[47] << 0x178)"]
#![doc = "   twos_complement_eval z = let x1 := z[0] + (z[1] << 64) + (z[2] << 128) + (z[3] << 192) + (z[4] << 256) + (z[5] << 0x140) in"]
#![doc = "                            if x1 & (2^384-1) < 2^383 then x1 & (2^384-1) else (x1 & (2^384-1)) - 2^384"]
#![allow(unused_parens)]
#![allow(non_camel_case_types)]
#![allow(
    dead_code,
    rustdoc::bare_urls,
    rustdoc::broken_intra_doc_links,
    unused_assignments,
    unused_mut,
    unused_variables
)]
pub type fiat_p384_u1 = u8;
pub type fiat_p384_i1 = i8;
pub type fiat_p384_u2 = u8;
pub type fiat_p384_i2 = i8;
pub type fiat_p384_montgomery_domain_field_element = [u64; 6];
pub type fiat_p384_non_montgomery_domain_field_element = [u64; 6];
#[doc = " The function fiat_p384_addcarryx_u64 is an addition with carry."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (arg1 + arg2 + arg3) mod 2^64"]
#[doc = "   out2 = ⌊(arg1 + arg2 + arg3) / 2^64⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffffffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   out2: [0x0 ~> 0x1]"]
#[inline]
pub const fn fiat_p384_addcarryx_u64(
    arg1: fiat_p384_u1,
    arg2: u64,
    arg3: u64,
) -> (u64, fiat_p384_u1) {
    let mut out1: u64 = 0;
    let mut out2: fiat_p384_u1 = 0;
    let x1: u128 = (((arg1 as u128) + (arg2 as u128)) + (arg3 as u128));
    let x2: u64 = ((x1 & (0xffffffffffffffff as u128)) as u64);
    let x3: fiat_p384_u1 = ((x1 >> 64) as fiat_p384_u1);
    out1 = x2;
    out2 = x3;
    (out1, out2)
}
#[doc = " The function fiat_p384_subborrowx_u64 is a subtraction with borrow."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (-arg1 + arg2 + -arg3) mod 2^64"]
#[doc = "   out2 = -⌊(-arg1 + arg2 + -arg3) / 2^64⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffffffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   out2: [0x0 ~> 0x1]"]
#[inline]
pub const fn fiat_p384_subborrowx_u64(
    arg1: fiat_p384_u1,
    arg2: u64,
    arg3: u64,
) -> (u64, fiat_p384_u1) {
    let mut out1: u64 = 0;
    let mut out2: fiat_p384_u1 = 0;
    let x1: i128 = (((arg2 as i128) - (arg1 as i128)) - (arg3 as i128));
    let x2: fiat_p384_i1 = ((x1 >> 64) as fiat_p384_i1);
    let x3: u64 = ((x1 & (0xffffffffffffffff as i128)) as u64);
    out1 = x3;
    out2 = (((0x0 as fiat_p384_i2) - (x2 as fiat_p384_i2)) as fiat_p384_u1);
    (out1, out2)
}
#[doc = " The function fiat_p384_mulx_u64 is a multiplication, returning the full double-width result."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (arg1 * arg2) mod 2^64"]
#[doc = "   out2 = ⌊arg1 * arg2 / 2^64⌋"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   arg2: [0x0 ~> 0xffffffffffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   out2: [0x0 ~> 0xffffffffffffffff]"]
#[inline]
pub const fn fiat_p384_mulx_u64(arg1: u64, arg2: u64) -> (u64, u64) {
    let mut out1: u64 = 0;
    let mut out2: u64 = 0;
    let x1: u128 = ((arg1 as u128) * (arg2 as u128));
    let x2: u64 = ((x1 & (0xffffffffffffffff as u128)) as u64);
    let x3: u64 = ((x1 >> 64) as u64);
    out1 = x2;
    out2 = x3;
    (out1, out2)
}
#[doc = " The function fiat_p384_cmovznz_u64 is a single-word conditional move."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if arg1 = 0 then arg2 else arg3)"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   arg3: [0x0 ~> 0xffffffffffffffff]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffffffffffff]"]
#[inline]
pub const fn fiat_p384_cmovznz_u64(arg1: fiat_p384_u1, arg2: u64, arg3: u64) -> u64 {
    let mut out1: u64 = 0;
    let x1: fiat_p384_u1 = (!(!arg1));
    let x2: u64 = ((((((0x0 as fiat_p384_i2) - (x1 as fiat_p384_i2)) as fiat_p384_i1) as i128)
        & (0xffffffffffffffff as i128)) as u64);
    let x3: u64 = ((x2 & arg3) | ((!x2) & arg2));
    out1 = x3;
    out1
}
#[doc = " The function fiat_p384_mul multiplies two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_mul(
    arg1: &fiat_p384_montgomery_domain_field_element,
    arg2: &fiat_p384_montgomery_domain_field_element,
) -> fiat_p384_montgomery_domain_field_element {
    let mut out1: fiat_p384_montgomery_domain_field_element = [0; 6];
    let x1: u64 = (arg1[1]);
    let x2: u64 = (arg1[2]);
    let x3: u64 = (arg1[3]);
    let x4: u64 = (arg1[4]);
    let x5: u64 = (arg1[5]);
    let x6: u64 = (arg1[0]);
    let mut x7: u64 = 0;
    let mut x8: u64 = 0;
    let (x7, x8) = fiat_p384_mulx_u64(x6, (arg2[5]));
    let mut x9: u64 = 0;
    let mut x10: u64 = 0;
    let (x9, x10) = fiat_p384_mulx_u64(x6, (arg2[4]));
    let mut x11: u64 = 0;
    let mut x12: u64 = 0;
    let (x11, x12) = fiat_p384_mulx_u64(x6, (arg2[3]));
    let mut x13: u64 = 0;
    let mut x14: u64 = 0;
    let (x13, x14) = fiat_p384_mulx_u64(x6, (arg2[2]));
    let mut x15: u64 = 0;
    let mut x16: u64 = 0;
    let (x15, x16) = fiat_p384_mulx_u64(x6, (arg2[1]));
    let mut x17: u64 = 0;
    let mut x18: u64 = 0;
    let (x17, x18) = fiat_p384_mulx_u64(x6, (arg2[0]));
    let mut x19: u64 = 0;
    let mut x20: fiat_p384_u1 = 0;
    let (x19, x20) = fiat_p384_addcarryx_u64(0x0, x18, x15);
    let mut x21: u64 = 0;
    let mut x22: fiat_p384_u1 = 0;
    let (x21, x22) = fiat_p384_addcarryx_u64(x20, x16, x13);
    let mut x23: u64 = 0;
    let mut x24: fiat_p384_u1 = 0;
    let (x23, x24) = fiat_p384_addcarryx_u64(x22, x14, x11);
    let mut x25: u64 = 0;
    let mut x26: fiat_p384_u1 = 0;
    let (x25, x26) = fiat_p384_addcarryx_u64(x24, x12, x9);
    let mut x27: u64 = 0;
    let mut x28: fiat_p384_u1 = 0;
    let (x27, x28) = fiat_p384_addcarryx_u64(x26, x10, x7);
    let x29: u64 = ((x28 as u64) + x8);
    let mut x30: u64 = 0;
    let mut x31: u64 = 0;
    let (x30, x31) = fiat_p384_mulx_u64(x17, 0x100000001);
    let mut x32: u64 = 0;
    let mut x33: u64 = 0;
    let (x32, x33) = fiat_p384_mulx_u64(x30, 0xffffffffffffffff);
    let mut x34: u64 = 0;
    let mut x35: u64 = 0;
    let (x34, x35) = fiat_p384_mulx_u64(x30, 0xffffffffffffffff);
    let mut x36: u64 = 0;
    let mut x37: u64 = 0;
    let (x36, x37) = fiat_p384_mulx_u64(x30, 0xffffffffffffffff);
    let mut x38: u64 = 0;
    let mut x39: u64 = 0;
    let (x38, x39) = fiat_p384_mulx_u64(x30, 0xfffffffffffffffe);
    let mut x40: u64 = 0;
    let mut x41: u64 = 0;
    let (x40, x41) = fiat_p384_mulx_u64(x30, 0xffffffff00000000);
    let mut x42: u64 = 0;
    let mut x43: u64 = 0;
    let (x42, x43) = fiat_p384_mulx_u64(x30, 0xffffffff);
    let mut x44: u64 = 0;
    let mut x45: fiat_p384_u1 = 0;
    let (x44, x45) = fiat_p384_addcarryx_u64(0x0, x43, x40);
    let mut x46: u64 = 0;
    let mut x47: fiat_p384_u1 = 0;
    let (x46, x47) = fiat_p384_addcarryx_u64(x45, x41, x38);
    let mut x48: u64 = 0;
    let mut x49: fiat_p384_u1 = 0;
    let (x48, x49) = fiat_p384_addcarryx_u64(x47, x39, x36);
    let mut x50: u64 = 0;
    let mut x51: fiat_p384_u1 = 0;
    let (x50, x51) = fiat_p384_addcarryx_u64(x49, x37, x34);
    let mut x52: u64 = 0;
    let mut x53: fiat_p384_u1 = 0;
    let (x52, x53) = fiat_p384_addcarryx_u64(x51, x35, x32);
    let x54: u64 = ((x53 as u64) + x33);
    let mut x55: u64 = 0;
    let mut x56: fiat_p384_u1 = 0;
    let (x55, x56) = fiat_p384_addcarryx_u64(0x0, x17, x42);
    let mut x57: u64 = 0;
    let mut x58: fiat_p384_u1 = 0;
    let (x57, x58) = fiat_p384_addcarryx_u64(x56, x19, x44);
    let mut x59: u64 = 0;
    let mut x60: fiat_p384_u1 = 0;
    let (x59, x60) = fiat_p384_addcarryx_u64(x58, x21, x46);
    let mut x61: u64 = 0;
    let mut x62: fiat_p384_u1 = 0;
    let (x61, x62) = fiat_p384_addcarryx_u64(x60, x23, x48);
    let mut x63: u64 = 0;
    let mut x64: fiat_p384_u1 = 0;
    let (x63, x64) = fiat_p384_addcarryx_u64(x62, x25, x50);
    let mut x65: u64 = 0;
    let mut x66: fiat_p384_u1 = 0;
    let (x65, x66) = fiat_p384_addcarryx_u64(x64, x27, x52);
    let mut x67: u64 = 0;
    let mut x68: fiat_p384_u1 = 0;
    let (x67, x68) = fiat_p384_addcarryx_u64(x66, x29, x54);
    let mut x69: u64 = 0;
    let mut x70: u64 = 0;
    let (x69, x70) = fiat_p384_mulx_u64(x1, (arg2[5]));
    let mut x71: u64 = 0;
    let mut x72: u64 = 0;
    let (x71, x72) = fiat_p384_mulx_u64(x1, (arg2[4]));
    let mut x73: u64 = 0;
    let mut x74: u64 = 0;
    let (x73, x74) = fiat_p384_mulx_u64(x1, (arg2[3]));
    let mut x75: u64 = 0;
    let mut x76: u64 = 0;
    let (x75, x76) = fiat_p384_mulx_u64(x1, (arg2[2]));
    let mut x77: u64 = 0;
    let mut x78: u64 = 0;
    let (x77, x78) = fiat_p384_mulx_u64(x1, (arg2[1]));
    let mut x79: u64 = 0;
    let mut x80: u64 = 0;
    let (x79, x80) = fiat_p384_mulx_u64(x1, (arg2[0]));
    let mut x81: u64 = 0;
    let mut x82: fiat_p384_u1 = 0;
    let (x81, x82) = fiat_p384_addcarryx_u64(0x0, x80, x77);
    let mut x83: u64 = 0;
    let mut x84: fiat_p384_u1 = 0;
    let (x83, x84) = fiat_p384_addcarryx_u64(x82, x78, x75);
    let mut x85: u64 = 0;
    let mut x86: fiat_p384_u1 = 0;
    let (x85, x86) = fiat_p384_addcarryx_u64(x84, x76, x73);
    let mut x87: u64 = 0;
    let mut x88: fiat_p384_u1 = 0;
    let (x87, x88) = fiat_p384_addcarryx_u64(x86, x74, x71);
    let mut x89: u64 = 0;
    let mut x90: fiat_p384_u1 = 0;
    let (x89, x90) = fiat_p384_addcarryx_u64(x88, x72, x69);
    let x91: u64 = ((x90 as u64) + x70);
    let mut x92: u64 = 0;
    let mut x93: fiat_p384_u1 = 0;
    let (x92, x93) = fiat_p384_addcarryx_u64(0x0, x57, x79);
    let mut x94: u64 = 0;
    let mut x95: fiat_p384_u1 = 0;
    let (x94, x95) = fiat_p384_addcarryx_u64(x93, x59, x81);
    let mut x96: u64 = 0;
    let mut x97: fiat_p384_u1 = 0;
    let (x96, x97) = fiat_p384_addcarryx_u64(x95, x61, x83);
    let mut x98: u64 = 0;
    let mut x99: fiat_p384_u1 = 0;
    let (x98, x99) = fiat_p384_addcarryx_u64(x97, x63, x85);
    let mut x100: u64 = 0;
    let mut x101: fiat_p384_u1 = 0;
    let (x100, x101) = fiat_p384_addcarryx_u64(x99, x65, x87);
    let mut x102: u64 = 0;
    let mut x103: fiat_p384_u1 = 0;
    let (x102, x103) = fiat_p384_addcarryx_u64(x101, x67, x89);
    let mut x104: u64 = 0;
    let mut x105: fiat_p384_u1 = 0;
    let (x104, x105) = fiat_p384_addcarryx_u64(x103, (x68 as u64), x91);
    let mut x106: u64 = 0;
    let mut x107: u64 = 0;
    let (x106, x107) = fiat_p384_mulx_u64(x92, 0x100000001);
    let mut x108: u64 = 0;
    let mut x109: u64 = 0;
    let (x108, x109) = fiat_p384_mulx_u64(x106, 0xffffffffffffffff);
    let mut x110: u64 = 0;
    let mut x111: u64 = 0;
    let (x110, x111) = fiat_p384_mulx_u64(x106, 0xffffffffffffffff);
    let mut x112: u64 = 0;
    let mut x113: u64 = 0;
    let (x112, x113) = fiat_p384_mulx_u64(x106, 0xffffffffffffffff);
    let mut x114: u64 = 0;
    let mut x115: u64 = 0;
    let (x114, x115) = fiat_p384_mulx_u64(x106, 0xfffffffffffffffe);
    let mut x116: u64 = 0;
    let mut x117: u64 = 0;
    let (x116, x117) = fiat_p384_mulx_u64(x106, 0xffffffff00000000);
    let mut x118: u64 = 0;
    let mut x119: u64 = 0;
    let (x118, x119) = fiat_p384_mulx_u64(x106, 0xffffffff);
    let mut x120: u64 = 0;
    let mut x121: fiat_p384_u1 = 0;
    let (x120, x121) = fiat_p384_addcarryx_u64(0x0, x119, x116);
    let mut x122: u64 = 0;
    let mut x123: fiat_p384_u1 = 0;
    let (x122, x123) = fiat_p384_addcarryx_u64(x121, x117, x114);
    let mut x124: u64 = 0;
    let mut x125: fiat_p384_u1 = 0;
    let (x124, x125) = fiat_p384_addcarryx_u64(x123, x115, x112);
    let mut x126: u64 = 0;
    let mut x127: fiat_p384_u1 = 0;
    let (x126, x127) = fiat_p384_addcarryx_u64(x125, x113, x110);
    let mut x128: u64 = 0;
    let mut x129: fiat_p384_u1 = 0;
    let (x128, x129) = fiat_p384_addcarryx_u64(x127, x111, x108);
    let x130: u64 = ((x129 as u64) + x109);
    let mut x131: u64 = 0;
    let mut x132: fiat_p384_u1 = 0;
    let (x131, x132) = fiat_p384_addcarryx_u64(0x0, x92, x118);
    let mut x133: u64 = 0;
    let mut x134: fiat_p384_u1 = 0;
    let (x133, x134) = fiat_p384_addcarryx_u64(x132, x94, x120);
    let mut x135: u64 = 0;
    let mut x136: fiat_p384_u1 = 0;
    let (x135, x136) = fiat_p384_addcarryx_u64(x134, x96, x122);
    let mut x137: u64 = 0;
    let mut x138: fiat_p384_u1 = 0;
    let (x137, x138) = fiat_p384_addcarryx_u64(x136, x98, x124);
    let mut x139: u64 = 0;
    let mut x140: fiat_p384_u1 = 0;
    let (x139, x140) = fiat_p384_addcarryx_u64(x138, x100, x126);
    let mut x141: u64 = 0;
    let mut x142: fiat_p384_u1 = 0;
    let (x141, x142) = fiat_p384_addcarryx_u64(x140, x102, x128);
    let mut x143: u64 = 0;
    let mut x144: fiat_p384_u1 = 0;
    let (x143, x144) = fiat_p384_addcarryx_u64(x142, x104, x130);
    let x145: u64 = ((x144 as u64) + (x105 as u64));
    let mut x146: u64 = 0;
    let mut x147: u64 = 0;
    let (x146, x147) = fiat_p384_mulx_u64(x2, (arg2[5]));
    let mut x148: u64 = 0;
    let mut x149: u64 = 0;
    let (x148, x149) = fiat_p384_mulx_u64(x2, (arg2[4]));
    let mut x150: u64 = 0;
    let mut x151: u64 = 0;
    let (x150, x151) = fiat_p384_mulx_u64(x2, (arg2[3]));
    let mut x152: u64 = 0;
    let mut x153: u64 = 0;
    let (x152, x153) = fiat_p384_mulx_u64(x2, (arg2[2]));
    let mut x154: u64 = 0;
    let mut x155: u64 = 0;
    let (x154, x155) = fiat_p384_mulx_u64(x2, (arg2[1]));
    let mut x156: u64 = 0;
    let mut x157: u64 = 0;
    let (x156, x157) = fiat_p384_mulx_u64(x2, (arg2[0]));
    let mut x158: u64 = 0;
    let mut x159: fiat_p384_u1 = 0;
    let (x158, x159) = fiat_p384_addcarryx_u64(0x0, x157, x154);
    let mut x160: u64 = 0;
    let mut x161: fiat_p384_u1 = 0;
    let (x160, x161) = fiat_p384_addcarryx_u64(x159, x155, x152);
    let mut x162: u64 = 0;
    let mut x163: fiat_p384_u1 = 0;
    let (x162, x163) = fiat_p384_addcarryx_u64(x161, x153, x150);
    let mut x164: u64 = 0;
    let mut x165: fiat_p384_u1 = 0;
    let (x164, x165) = fiat_p384_addcarryx_u64(x163, x151, x148);
    let mut x166: u64 = 0;
    let mut x167: fiat_p384_u1 = 0;
    let (x166, x167) = fiat_p384_addcarryx_u64(x165, x149, x146);
    let x168: u64 = ((x167 as u64) + x147);
    let mut x169: u64 = 0;
    let mut x170: fiat_p384_u1 = 0;
    let (x169, x170) = fiat_p384_addcarryx_u64(0x0, x133, x156);
    let mut x171: u64 = 0;
    let mut x172: fiat_p384_u1 = 0;
    let (x171, x172) = fiat_p384_addcarryx_u64(x170, x135, x158);
    let mut x173: u64 = 0;
    let mut x174: fiat_p384_u1 = 0;
    let (x173, x174) = fiat_p384_addcarryx_u64(x172, x137, x160);
    let mut x175: u64 = 0;
    let mut x176: fiat_p384_u1 = 0;
    let (x175, x176) = fiat_p384_addcarryx_u64(x174, x139, x162);
    let mut x177: u64 = 0;
    let mut x178: fiat_p384_u1 = 0;
    let (x177, x178) = fiat_p384_addcarryx_u64(x176, x141, x164);
    let mut x179: u64 = 0;
    let mut x180: fiat_p384_u1 = 0;
    let (x179, x180) = fiat_p384_addcarryx_u64(x178, x143, x166);
    let mut x181: u64 = 0;
    let mut x182: fiat_p384_u1 = 0;
    let (x181, x182) = fiat_p384_addcarryx_u64(x180, x145, x168);
    let mut x183: u64 = 0;
    let mut x184: u64 = 0;
    let (x183, x184) = fiat_p384_mulx_u64(x169, 0x100000001);
    let mut x185: u64 = 0;
    let mut x186: u64 = 0;
    let (x185, x186) = fiat_p384_mulx_u64(x183, 0xffffffffffffffff);
    let mut x187: u64 = 0;
    let mut x188: u64 = 0;
    let (x187, x188) = fiat_p384_mulx_u64(x183, 0xffffffffffffffff);
    let mut x189: u64 = 0;
    let mut x190: u64 = 0;
    let (x189, x190) = fiat_p384_mulx_u64(x183, 0xffffffffffffffff);
    let mut x191: u64 = 0;
    let mut x192: u64 = 0;
    let (x191, x192) = fiat_p384_mulx_u64(x183, 0xfffffffffffffffe);
    let mut x193: u64 = 0;
    let mut x194: u64 = 0;
    let (x193, x194) = fiat_p384_mulx_u64(x183, 0xffffffff00000000);
    let mut x195: u64 = 0;
    let mut x196: u64 = 0;
    let (x195, x196) = fiat_p384_mulx_u64(x183, 0xffffffff);
    let mut x197: u64 = 0;
    let mut x198: fiat_p384_u1 = 0;
    let (x197, x198) = fiat_p384_addcarryx_u64(0x0, x196, x193);
    let mut x199: u64 = 0;
    let mut x200: fiat_p384_u1 = 0;
    let (x199, x200) = fiat_p384_addcarryx_u64(x198, x194, x191);
    let mut x201: u64 = 0;
    let mut x202: fiat_p384_u1 = 0;
    let (x201, x202) = fiat_p384_addcarryx_u64(x200, x192, x189);
    let mut x203: u64 = 0;
    let mut x204: fiat_p384_u1 = 0;
    let (x203, x204) = fiat_p384_addcarryx_u64(x202, x190, x187);
    let mut x205: u64 = 0;
    let mut x206: fiat_p384_u1 = 0;
    let (x205, x206) = fiat_p384_addcarryx_u64(x204, x188, x185);
    let x207: u64 = ((x206 as u64) + x186);
    let mut x208: u64 = 0;
    let mut x209: fiat_p384_u1 = 0;
    let (x208, x209) = fiat_p384_addcarryx_u64(0x0, x169, x195);
    let mut x210: u64 = 0;
    let mut x211: fiat_p384_u1 = 0;
    let (x210, x211) = fiat_p384_addcarryx_u64(x209, x171, x197);
    let mut x212: u64 = 0;
    let mut x213: fiat_p384_u1 = 0;
    let (x212, x213) = fiat_p384_addcarryx_u64(x211, x173, x199);
    let mut x214: u64 = 0;
    let mut x215: fiat_p384_u1 = 0;
    let (x214, x215) = fiat_p384_addcarryx_u64(x213, x175, x201);
    let mut x216: u64 = 0;
    let mut x217: fiat_p384_u1 = 0;
    let (x216, x217) = fiat_p384_addcarryx_u64(x215, x177, x203);
    let mut x218: u64 = 0;
    let mut x219: fiat_p384_u1 = 0;
    let (x218, x219) = fiat_p384_addcarryx_u64(x217, x179, x205);
    let mut x220: u64 = 0;
    let mut x221: fiat_p384_u1 = 0;
    let (x220, x221) = fiat_p384_addcarryx_u64(x219, x181, x207);
    let x222: u64 = ((x221 as u64) + (x182 as u64));
    let mut x223: u64 = 0;
    let mut x224: u64 = 0;
    let (x223, x224) = fiat_p384_mulx_u64(x3, (arg2[5]));
    let mut x225: u64 = 0;
    let mut x226: u64 = 0;
    let (x225, x226) = fiat_p384_mulx_u64(x3, (arg2[4]));
    let mut x227: u64 = 0;
    let mut x228: u64 = 0;
    let (x227, x228) = fiat_p384_mulx_u64(x3, (arg2[3]));
    let mut x229: u64 = 0;
    let mut x230: u64 = 0;
    let (x229, x230) = fiat_p384_mulx_u64(x3, (arg2[2]));
    let mut x231: u64 = 0;
    let mut x232: u64 = 0;
    let (x231, x232) = fiat_p384_mulx_u64(x3, (arg2[1]));
    let mut x233: u64 = 0;
    let mut x234: u64 = 0;
    let (x233, x234) = fiat_p384_mulx_u64(x3, (arg2[0]));
    let mut x235: u64 = 0;
    let mut x236: fiat_p384_u1 = 0;
    let (x235, x236) = fiat_p384_addcarryx_u64(0x0, x234, x231);
    let mut x237: u64 = 0;
    let mut x238: fiat_p384_u1 = 0;
    let (x237, x238) = fiat_p384_addcarryx_u64(x236, x232, x229);
    let mut x239: u64 = 0;
    let mut x240: fiat_p384_u1 = 0;
    let (x239, x240) = fiat_p384_addcarryx_u64(x238, x230, x227);
    let mut x241: u64 = 0;
    let mut x242: fiat_p384_u1 = 0;
    let (x241, x242) = fiat_p384_addcarryx_u64(x240, x228, x225);
    let mut x243: u64 = 0;
    let mut x244: fiat_p384_u1 = 0;
    let (x243, x244) = fiat_p384_addcarryx_u64(x242, x226, x223);
    let x245: u64 = ((x244 as u64) + x224);
    let mut x246: u64 = 0;
    let mut x247: fiat_p384_u1 = 0;
    let (x246, x247) = fiat_p384_addcarryx_u64(0x0, x210, x233);
    let mut x248: u64 = 0;
    let mut x249: fiat_p384_u1 = 0;
    let (x248, x249) = fiat_p384_addcarryx_u64(x247, x212, x235);
    let mut x250: u64 = 0;
    let mut x251: fiat_p384_u1 = 0;
    let (x250, x251) = fiat_p384_addcarryx_u64(x249, x214, x237);
    let mut x252: u64 = 0;
    let mut x253: fiat_p384_u1 = 0;
    let (x252, x253) = fiat_p384_addcarryx_u64(x251, x216, x239);
    let mut x254: u64 = 0;
    let mut x255: fiat_p384_u1 = 0;
    let (x254, x255) = fiat_p384_addcarryx_u64(x253, x218, x241);
    let mut x256: u64 = 0;
    let mut x257: fiat_p384_u1 = 0;
    let (x256, x257) = fiat_p384_addcarryx_u64(x255, x220, x243);
    let mut x258: u64 = 0;
    let mut x259: fiat_p384_u1 = 0;
    let (x258, x259) = fiat_p384_addcarryx_u64(x257, x222, x245);
    let mut x260: u64 = 0;
    let mut x261: u64 = 0;
    let (x260, x261) = fiat_p384_mulx_u64(x246, 0x100000001);
    let mut x262: u64 = 0;
    let mut x263: u64 = 0;
    let (x262, x263) = fiat_p384_mulx_u64(x260, 0xffffffffffffffff);
    let mut x264: u64 = 0;
    let mut x265: u64 = 0;
    let (x264, x265) = fiat_p384_mulx_u64(x260, 0xffffffffffffffff);
    let mut x266: u64 = 0;
    let mut x267: u64 = 0;
    let (x266, x267) = fiat_p384_mulx_u64(x260, 0xffffffffffffffff);
    let mut x268: u64 = 0;
    let mut x269: u64 = 0;
    let (x268, x269) = fiat_p384_mulx_u64(x260, 0xfffffffffffffffe);
    let mut x270: u64 = 0;
    let mut x271: u64 = 0;
    let (x270, x271) = fiat_p384_mulx_u64(x260, 0xffffffff00000000);
    let mut x272: u64 = 0;
    let mut x273: u64 = 0;
    let (x272, x273) = fiat_p384_mulx_u64(x260, 0xffffffff);
    let mut x274: u64 = 0;
    let mut x275: fiat_p384_u1 = 0;
    let (x274, x275) = fiat_p384_addcarryx_u64(0x0, x273, x270);
    let mut x276: u64 = 0;
    let mut x277: fiat_p384_u1 = 0;
    let (x276, x277) = fiat_p384_addcarryx_u64(x275, x271, x268);
    let mut x278: u64 = 0;
    let mut x279: fiat_p384_u1 = 0;
    let (x278, x279) = fiat_p384_addcarryx_u64(x277, x269, x266);
    let mut x280: u64 = 0;
    let mut x281: fiat_p384_u1 = 0;
    let (x280, x281) = fiat_p384_addcarryx_u64(x279, x267, x264);
    let mut x282: u64 = 0;
    let mut x283: fiat_p384_u1 = 0;
    let (x282, x283) = fiat_p384_addcarryx_u64(x281, x265, x262);
    let x284: u64 = ((x283 as u64) + x263);
    let mut x285: u64 = 0;
    let mut x286: fiat_p384_u1 = 0;
    let (x285, x286) = fiat_p384_addcarryx_u64(0x0, x246, x272);
    let mut x287: u64 = 0;
    let mut x288: fiat_p384_u1 = 0;
    let (x287, x288) = fiat_p384_addcarryx_u64(x286, x248, x274);
    let mut x289: u64 = 0;
    let mut x290: fiat_p384_u1 = 0;
    let (x289, x290) = fiat_p384_addcarryx_u64(x288, x250, x276);
    let mut x291: u64 = 0;
    let mut x292: fiat_p384_u1 = 0;
    let (x291, x292) = fiat_p384_addcarryx_u64(x290, x252, x278);
    let mut x293: u64 = 0;
    let mut x294: fiat_p384_u1 = 0;
    let (x293, x294) = fiat_p384_addcarryx_u64(x292, x254, x280);
    let mut x295: u64 = 0;
    let mut x296: fiat_p384_u1 = 0;
    let (x295, x296) = fiat_p384_addcarryx_u64(x294, x256, x282);
    let mut x297: u64 = 0;
    let mut x298: fiat_p384_u1 = 0;
    let (x297, x298) = fiat_p384_addcarryx_u64(x296, x258, x284);
    let x299: u64 = ((x298 as u64) + (x259 as u64));
    let mut x300: u64 = 0;
    let mut x301: u64 = 0;
    let (x300, x301) = fiat_p384_mulx_u64(x4, (arg2[5]));
    let mut x302: u64 = 0;
    let mut x303: u64 = 0;
    let (x302, x303) = fiat_p384_mulx_u64(x4, (arg2[4]));
    let mut x304: u64 = 0;
    let mut x305: u64 = 0;
    let (x304, x305) = fiat_p384_mulx_u64(x4, (arg2[3]));
    let mut x306: u64 = 0;
    let mut x307: u64 = 0;
    let (x306, x307) = fiat_p384_mulx_u64(x4, (arg2[2]));
    let mut x308: u64 = 0;
    let mut x309: u64 = 0;
    let (x308, x309) = fiat_p384_mulx_u64(x4, (arg2[1]));
    let mut x310: u64 = 0;
    let mut x311: u64 = 0;
    let (x310, x311) = fiat_p384_mulx_u64(x4, (arg2[0]));
    let mut x312: u64 = 0;
    let mut x313: fiat_p384_u1 = 0;
    let (x312, x313) = fiat_p384_addcarryx_u64(0x0, x311, x308);
    let mut x314: u64 = 0;
    let mut x315: fiat_p384_u1 = 0;
    let (x314, x315) = fiat_p384_addcarryx_u64(x313, x309, x306);
    let mut x316: u64 = 0;
    let mut x317: fiat_p384_u1 = 0;
    let (x316, x317) = fiat_p384_addcarryx_u64(x315, x307, x304);
    let mut x318: u64 = 0;
    let mut x319: fiat_p384_u1 = 0;
    let (x318, x319) = fiat_p384_addcarryx_u64(x317, x305, x302);
    let mut x320: u64 = 0;
    let mut x321: fiat_p384_u1 = 0;
    let (x320, x321) = fiat_p384_addcarryx_u64(x319, x303, x300);
    let x322: u64 = ((x321 as u64) + x301);
    let mut x323: u64 = 0;
    let mut x324: fiat_p384_u1 = 0;
    let (x323, x324) = fiat_p384_addcarryx_u64(0x0, x287, x310);
    let mut x325: u64 = 0;
    let mut x326: fiat_p384_u1 = 0;
    let (x325, x326) = fiat_p384_addcarryx_u64(x324, x289, x312);
    let mut x327: u64 = 0;
    let mut x328: fiat_p384_u1 = 0;
    let (x327, x328) = fiat_p384_addcarryx_u64(x326, x291, x314);
    let mut x329: u64 = 0;
    let mut x330: fiat_p384_u1 = 0;
    let (x329, x330) = fiat_p384_addcarryx_u64(x328, x293, x316);
    let mut x331: u64 = 0;
    let mut x332: fiat_p384_u1 = 0;
    let (x331, x332) = fiat_p384_addcarryx_u64(x330, x295, x318);
    let mut x333: u64 = 0;
    let mut x334: fiat_p384_u1 = 0;
    let (x333, x334) = fiat_p384_addcarryx_u64(x332, x297, x320);
    let mut x335: u64 = 0;
    let mut x336: fiat_p384_u1 = 0;
    let (x335, x336) = fiat_p384_addcarryx_u64(x334, x299, x322);
    let mut x337: u64 = 0;
    let mut x338: u64 = 0;
    let (x337, x338) = fiat_p384_mulx_u64(x323, 0x100000001);
    let mut x339: u64 = 0;
    let mut x340: u64 = 0;
    let (x339, x340) = fiat_p384_mulx_u64(x337, 0xffffffffffffffff);
    let mut x341: u64 = 0;
    let mut x342: u64 = 0;
    let (x341, x342) = fiat_p384_mulx_u64(x337, 0xffffffffffffffff);
    let mut x343: u64 = 0;
    let mut x344: u64 = 0;
    let (x343, x344) = fiat_p384_mulx_u64(x337, 0xffffffffffffffff);
    let mut x345: u64 = 0;
    let mut x346: u64 = 0;
    let (x345, x346) = fiat_p384_mulx_u64(x337, 0xfffffffffffffffe);
    let mut x347: u64 = 0;
    let mut x348: u64 = 0;
    let (x347, x348) = fiat_p384_mulx_u64(x337, 0xffffffff00000000);
    let mut x349: u64 = 0;
    let mut x350: u64 = 0;
    let (x349, x350) = fiat_p384_mulx_u64(x337, 0xffffffff);
    let mut x351: u64 = 0;
    let mut x352: fiat_p384_u1 = 0;
    let (x351, x352) = fiat_p384_addcarryx_u64(0x0, x350, x347);
    let mut x353: u64 = 0;
    let mut x354: fiat_p384_u1 = 0;
    let (x353, x354) = fiat_p384_addcarryx_u64(x352, x348, x345);
    let mut x355: u64 = 0;
    let mut x356: fiat_p384_u1 = 0;
    let (x355, x356) = fiat_p384_addcarryx_u64(x354, x346, x343);
    let mut x357: u64 = 0;
    let mut x358: fiat_p384_u1 = 0;
    let (x357, x358) = fiat_p384_addcarryx_u64(x356, x344, x341);
    let mut x359: u64 = 0;
    let mut x360: fiat_p384_u1 = 0;
    let (x359, x360) = fiat_p384_addcarryx_u64(x358, x342, x339);
    let x361: u64 = ((x360 as u64) + x340);
    let mut x362: u64 = 0;
    let mut x363: fiat_p384_u1 = 0;
    let (x362, x363) = fiat_p384_addcarryx_u64(0x0, x323, x349);
    let mut x364: u64 = 0;
    let mut x365: fiat_p384_u1 = 0;
    let (x364, x365) = fiat_p384_addcarryx_u64(x363, x325, x351);
    let mut x366: u64 = 0;
    let mut x367: fiat_p384_u1 = 0;
    let (x366, x367) = fiat_p384_addcarryx_u64(x365, x327, x353);
    let mut x368: u64 = 0;
    let mut x369: fiat_p384_u1 = 0;
    let (x368, x369) = fiat_p384_addcarryx_u64(x367, x329, x355);
    let mut x370: u64 = 0;
    let mut x371: fiat_p384_u1 = 0;
    let (x370, x371) = fiat_p384_addcarryx_u64(x369, x331, x357);
    let mut x372: u64 = 0;
    let mut x373: fiat_p384_u1 = 0;
    let (x372, x373) = fiat_p384_addcarryx_u64(x371, x333, x359);
    let mut x374: u64 = 0;
    let mut x375: fiat_p384_u1 = 0;
    let (x374, x375) = fiat_p384_addcarryx_u64(x373, x335, x361);
    let x376: u64 = ((x375 as u64) + (x336 as u64));
    let mut x377: u64 = 0;
    let mut x378: u64 = 0;
    let (x377, x378) = fiat_p384_mulx_u64(x5, (arg2[5]));
    let mut x379: u64 = 0;
    let mut x380: u64 = 0;
    let (x379, x380) = fiat_p384_mulx_u64(x5, (arg2[4]));
    let mut x381: u64 = 0;
    let mut x382: u64 = 0;
    let (x381, x382) = fiat_p384_mulx_u64(x5, (arg2[3]));
    let mut x383: u64 = 0;
    let mut x384: u64 = 0;
    let (x383, x384) = fiat_p384_mulx_u64(x5, (arg2[2]));
    let mut x385: u64 = 0;
    let mut x386: u64 = 0;
    let (x385, x386) = fiat_p384_mulx_u64(x5, (arg2[1]));
    let mut x387: u64 = 0;
    let mut x388: u64 = 0;
    let (x387, x388) = fiat_p384_mulx_u64(x5, (arg2[0]));
    let mut x389: u64 = 0;
    let mut x390: fiat_p384_u1 = 0;
    let (x389, x390) = fiat_p384_addcarryx_u64(0x0, x388, x385);
    let mut x391: u64 = 0;
    let mut x392: fiat_p384_u1 = 0;
    let (x391, x392) = fiat_p384_addcarryx_u64(x390, x386, x383);
    let mut x393: u64 = 0;
    let mut x394: fiat_p384_u1 = 0;
    let (x393, x394) = fiat_p384_addcarryx_u64(x392, x384, x381);
    let mut x395: u64 = 0;
    let mut x396: fiat_p384_u1 = 0;
    let (x395, x396) = fiat_p384_addcarryx_u64(x394, x382, x379);
    let mut x397: u64 = 0;
    let mut x398: fiat_p384_u1 = 0;
    let (x397, x398) = fiat_p384_addcarryx_u64(x396, x380, x377);
    let x399: u64 = ((x398 as u64) + x378);
    let mut x400: u64 = 0;
    let mut x401: fiat_p384_u1 = 0;
    let (x400, x401) = fiat_p384_addcarryx_u64(0x0, x364, x387);
    let mut x402: u64 = 0;
    let mut x403: fiat_p384_u1 = 0;
    let (x402, x403) = fiat_p384_addcarryx_u64(x401, x366, x389);
    let mut x404: u64 = 0;
    let mut x405: fiat_p384_u1 = 0;
    let (x404, x405) = fiat_p384_addcarryx_u64(x403, x368, x391);
    let mut x406: u64 = 0;
    let mut x407: fiat_p384_u1 = 0;
    let (x406, x407) = fiat_p384_addcarryx_u64(x405, x370, x393);
    let mut x408: u64 = 0;
    let mut x409: fiat_p384_u1 = 0;
    let (x408, x409) = fiat_p384_addcarryx_u64(x407, x372, x395);
    let mut x410: u64 = 0;
    let mut x411: fiat_p384_u1 = 0;
    let (x410, x411) = fiat_p384_addcarryx_u64(x409, x374, x397);
    let mut x412: u64 = 0;
    let mut x413: fiat_p384_u1 = 0;
    let (x412, x413) = fiat_p384_addcarryx_u64(x411, x376, x399);
    let mut x414: u64 = 0;
    let mut x415: u64 = 0;
    let (x414, x415) = fiat_p384_mulx_u64(x400, 0x100000001);
    let mut x416: u64 = 0;
    let mut x417: u64 = 0;
    let (x416, x417) = fiat_p384_mulx_u64(x414, 0xffffffffffffffff);
    let mut x418: u64 = 0;
    let mut x419: u64 = 0;
    let (x418, x419) = fiat_p384_mulx_u64(x414, 0xffffffffffffffff);
    let mut x420: u64 = 0;
    let mut x421: u64 = 0;
    let (x420, x421) = fiat_p384_mulx_u64(x414, 0xffffffffffffffff);
    let mut x422: u64 = 0;
    let mut x423: u64 = 0;
    let (x422, x423) = fiat_p384_mulx_u64(x414, 0xfffffffffffffffe);
    let mut x424: u64 = 0;
    let mut x425: u64 = 0;
    let (x424, x425) = fiat_p384_mulx_u64(x414, 0xffffffff00000000);
    let mut x426: u64 = 0;
    let mut x427: u64 = 0;
    let (x426, x427) = fiat_p384_mulx_u64(x414, 0xffffffff);
    let mut x428: u64 = 0;
    let mut x429: fiat_p384_u1 = 0;
    let (x428, x429) = fiat_p384_addcarryx_u64(0x0, x427, x424);
    let mut x430: u64 = 0;
    let mut x431: fiat_p384_u1 = 0;
    let (x430, x431) = fiat_p384_addcarryx_u64(x429, x425, x422);
    let mut x432: u64 = 0;
    let mut x433: fiat_p384_u1 = 0;
    let (x432, x433) = fiat_p384_addcarryx_u64(x431, x423, x420);
    let mut x434: u64 = 0;
    let mut x435: fiat_p384_u1 = 0;
    let (x434, x435) = fiat_p384_addcarryx_u64(x433, x421, x418);
    let mut x436: u64 = 0;
    let mut x437: fiat_p384_u1 = 0;
    let (x436, x437) = fiat_p384_addcarryx_u64(x435, x419, x416);
    let x438: u64 = ((x437 as u64) + x417);
    let mut x439: u64 = 0;
    let mut x440: fiat_p384_u1 = 0;
    let (x439, x440) = fiat_p384_addcarryx_u64(0x0, x400, x426);
    let mut x441: u64 = 0;
    let mut x442: fiat_p384_u1 = 0;
    let (x441, x442) = fiat_p384_addcarryx_u64(x440, x402, x428);
    let mut x443: u64 = 0;
    let mut x444: fiat_p384_u1 = 0;
    let (x443, x444) = fiat_p384_addcarryx_u64(x442, x404, x430);
    let mut x445: u64 = 0;
    let mut x446: fiat_p384_u1 = 0;
    let (x445, x446) = fiat_p384_addcarryx_u64(x444, x406, x432);
    let mut x447: u64 = 0;
    let mut x448: fiat_p384_u1 = 0;
    let (x447, x448) = fiat_p384_addcarryx_u64(x446, x408, x434);
    let mut x449: u64 = 0;
    let mut x450: fiat_p384_u1 = 0;
    let (x449, x450) = fiat_p384_addcarryx_u64(x448, x410, x436);
    let mut x451: u64 = 0;
    let mut x452: fiat_p384_u1 = 0;
    let (x451, x452) = fiat_p384_addcarryx_u64(x450, x412, x438);
    let x453: u64 = ((x452 as u64) + (x413 as u64));
    let mut x454: u64 = 0;
    let mut x455: fiat_p384_u1 = 0;
    let (x454, x455) = fiat_p384_subborrowx_u64(0x0, x441, 0xffffffff);
    let mut x456: u64 = 0;
    let mut x457: fiat_p384_u1 = 0;
    let (x456, x457) = fiat_p384_subborrowx_u64(x455, x443, 0xffffffff00000000);
    let mut x458: u64 = 0;
    let mut x459: fiat_p384_u1 = 0;
    let (x458, x459) = fiat_p384_subborrowx_u64(x457, x445, 0xfffffffffffffffe);
    let mut x460: u64 = 0;
    let mut x461: fiat_p384_u1 = 0;
    let (x460, x461) = fiat_p384_subborrowx_u64(x459, x447, 0xffffffffffffffff);
    let mut x462: u64 = 0;
    let mut x463: fiat_p384_u1 = 0;
    let (x462, x463) = fiat_p384_subborrowx_u64(x461, x449, 0xffffffffffffffff);
    let mut x464: u64 = 0;
    let mut x465: fiat_p384_u1 = 0;
    let (x464, x465) = fiat_p384_subborrowx_u64(x463, x451, 0xffffffffffffffff);
    let mut x466: u64 = 0;
    let mut x467: fiat_p384_u1 = 0;
    let (x466, x467) = fiat_p384_subborrowx_u64(x465, x453, (0x0 as u64));
    let mut x468: u64 = 0;
    let (x468) = fiat_p384_cmovznz_u64(x467, x454, x441);
    let mut x469: u64 = 0;
    let (x469) = fiat_p384_cmovznz_u64(x467, x456, x443);
    let mut x470: u64 = 0;
    let (x470) = fiat_p384_cmovznz_u64(x467, x458, x445);
    let mut x471: u64 = 0;
    let (x471) = fiat_p384_cmovznz_u64(x467, x460, x447);
    let mut x472: u64 = 0;
    let (x472) = fiat_p384_cmovznz_u64(x467, x462, x449);
    let mut x473: u64 = 0;
    let (x473) = fiat_p384_cmovznz_u64(x467, x464, x451);
    out1[0] = x468;
    out1[1] = x469;
    out1[2] = x470;
    out1[3] = x471;
    out1[4] = x472;
    out1[5] = x473;
    out1
}
#[doc = " The function fiat_p384_square squares a field element in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) * eval (from_montgomery arg1)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_square(
    arg1: &fiat_p384_montgomery_domain_field_element,
) -> fiat_p384_montgomery_domain_field_element {
    let mut out1: fiat_p384_montgomery_domain_field_element = [0; 6];
    let x1: u64 = (arg1[1]);
    let x2: u64 = (arg1[2]);
    let x3: u64 = (arg1[3]);
    let x4: u64 = (arg1[4]);
    let x5: u64 = (arg1[5]);
    let x6: u64 = (arg1[0]);
    let mut x7: u64 = 0;
    let mut x8: u64 = 0;
    let (x7, x8) = fiat_p384_mulx_u64(x6, (arg1[5]));
    let mut x9: u64 = 0;
    let mut x10: u64 = 0;
    let (x9, x10) = fiat_p384_mulx_u64(x6, (arg1[4]));
    let mut x11: u64 = 0;
    let mut x12: u64 = 0;
    let (x11, x12) = fiat_p384_mulx_u64(x6, (arg1[3]));
    let mut x13: u64 = 0;
    let mut x14: u64 = 0;
    let (x13, x14) = fiat_p384_mulx_u64(x6, (arg1[2]));
    let mut x15: u64 = 0;
    let mut x16: u64 = 0;
    let (x15, x16) = fiat_p384_mulx_u64(x6, (arg1[1]));
    let mut x17: u64 = 0;
    let mut x18: u64 = 0;
    let (x17, x18) = fiat_p384_mulx_u64(x6, (arg1[0]));
    let mut x19: u64 = 0;
    let mut x20: fiat_p384_u1 = 0;
    let (x19, x20) = fiat_p384_addcarryx_u64(0x0, x18, x15);
    let mut x21: u64 = 0;
    let mut x22: fiat_p384_u1 = 0;
    let (x21, x22) = fiat_p384_addcarryx_u64(x20, x16, x13);
    let mut x23: u64 = 0;
    let mut x24: fiat_p384_u1 = 0;
    let (x23, x24) = fiat_p384_addcarryx_u64(x22, x14, x11);
    let mut x25: u64 = 0;
    let mut x26: fiat_p384_u1 = 0;
    let (x25, x26) = fiat_p384_addcarryx_u64(x24, x12, x9);
    let mut x27: u64 = 0;
    let mut x28: fiat_p384_u1 = 0;
    let (x27, x28) = fiat_p384_addcarryx_u64(x26, x10, x7);
    let x29: u64 = ((x28 as u64) + x8);
    let mut x30: u64 = 0;
    let mut x31: u64 = 0;
    let (x30, x31) = fiat_p384_mulx_u64(x17, 0x100000001);
    let mut x32: u64 = 0;
    let mut x33: u64 = 0;
    let (x32, x33) = fiat_p384_mulx_u64(x30, 0xffffffffffffffff);
    let mut x34: u64 = 0;
    let mut x35: u64 = 0;
    let (x34, x35) = fiat_p384_mulx_u64(x30, 0xffffffffffffffff);
    let mut x36: u64 = 0;
    let mut x37: u64 = 0;
    let (x36, x37) = fiat_p384_mulx_u64(x30, 0xffffffffffffffff);
    let mut x38: u64 = 0;
    let mut x39: u64 = 0;
    let (x38, x39) = fiat_p384_mulx_u64(x30, 0xfffffffffffffffe);
    let mut x40: u64 = 0;
    let mut x41: u64 = 0;
    let (x40, x41) = fiat_p384_mulx_u64(x30, 0xffffffff00000000);
    let mut x42: u64 = 0;
    let mut x43: u64 = 0;
    let (x42, x43) = fiat_p384_mulx_u64(x30, 0xffffffff);
    let mut x44: u64 = 0;
    let mut x45: fiat_p384_u1 = 0;
    let (x44, x45) = fiat_p384_addcarryx_u64(0x0, x43, x40);
    let mut x46: u64 = 0;
    let mut x47: fiat_p384_u1 = 0;
    let (x46, x47) = fiat_p384_addcarryx_u64(x45, x41, x38);
    let mut x48: u64 = 0;
    let mut x49: fiat_p384_u1 = 0;
    let (x48, x49) = fiat_p384_addcarryx_u64(x47, x39, x36);
    let mut x50: u64 = 0;
    let mut x51: fiat_p384_u1 = 0;
    let (x50, x51) = fiat_p384_addcarryx_u64(x49, x37, x34);
    let mut x52: u64 = 0;
    let mut x53: fiat_p384_u1 = 0;
    let (x52, x53) = fiat_p384_addcarryx_u64(x51, x35, x32);
    let x54: u64 = ((x53 as u64) + x33);
    let mut x55: u64 = 0;
    let mut x56: fiat_p384_u1 = 0;
    let (x55, x56) = fiat_p384_addcarryx_u64(0x0, x17, x42);
    let mut x57: u64 = 0;
    let mut x58: fiat_p384_u1 = 0;
    let (x57, x58) = fiat_p384_addcarryx_u64(x56, x19, x44);
    let mut x59: u64 = 0;
    let mut x60: fiat_p384_u1 = 0;
    let (x59, x60) = fiat_p384_addcarryx_u64(x58, x21, x46);
    let mut x61: u64 = 0;
    let mut x62: fiat_p384_u1 = 0;
    let (x61, x62) = fiat_p384_addcarryx_u64(x60, x23, x48);
    let mut x63: u64 = 0;
    let mut x64: fiat_p384_u1 = 0;
    let (x63, x64) = fiat_p384_addcarryx_u64(x62, x25, x50);
    let mut x65: u64 = 0;
    let mut x66: fiat_p384_u1 = 0;
    let (x65, x66) = fiat_p384_addcarryx_u64(x64, x27, x52);
    let mut x67: u64 = 0;
    let mut x68: fiat_p384_u1 = 0;
    let (x67, x68) = fiat_p384_addcarryx_u64(x66, x29, x54);
    let mut x69: u64 = 0;
    let mut x70: u64 = 0;
    let (x69, x70) = fiat_p384_mulx_u64(x1, (arg1[5]));
    let mut x71: u64 = 0;
    let mut x72: u64 = 0;
    let (x71, x72) = fiat_p384_mulx_u64(x1, (arg1[4]));
    let mut x73: u64 = 0;
    let mut x74: u64 = 0;
    let (x73, x74) = fiat_p384_mulx_u64(x1, (arg1[3]));
    let mut x75: u64 = 0;
    let mut x76: u64 = 0;
    let (x75, x76) = fiat_p384_mulx_u64(x1, (arg1[2]));
    let mut x77: u64 = 0;
    let mut x78: u64 = 0;
    let (x77, x78) = fiat_p384_mulx_u64(x1, (arg1[1]));
    let mut x79: u64 = 0;
    let mut x80: u64 = 0;
    let (x79, x80) = fiat_p384_mulx_u64(x1, (arg1[0]));
    let mut x81: u64 = 0;
    let mut x82: fiat_p384_u1 = 0;
    let (x81, x82) = fiat_p384_addcarryx_u64(0x0, x80, x77);
    let mut x83: u64 = 0;
    let mut x84: fiat_p384_u1 = 0;
    let (x83, x84) = fiat_p384_addcarryx_u64(x82, x78, x75);
    let mut x85: u64 = 0;
    let mut x86: fiat_p384_u1 = 0;
    let (x85, x86) = fiat_p384_addcarryx_u64(x84, x76, x73);
    let mut x87: u64 = 0;
    let mut x88: fiat_p384_u1 = 0;
    let (x87, x88) = fiat_p384_addcarryx_u64(x86, x74, x71);
    let mut x89: u64 = 0;
    let mut x90: fiat_p384_u1 = 0;
    let (x89, x90) = fiat_p384_addcarryx_u64(x88, x72, x69);
    let x91: u64 = ((x90 as u64) + x70);
    let mut x92: u64 = 0;
    let mut x93: fiat_p384_u1 = 0;
    let (x92, x93) = fiat_p384_addcarryx_u64(0x0, x57, x79);
    let mut x94: u64 = 0;
    let mut x95: fiat_p384_u1 = 0;
    let (x94, x95) = fiat_p384_addcarryx_u64(x93, x59, x81);
    let mut x96: u64 = 0;
    let mut x97: fiat_p384_u1 = 0;
    let (x96, x97) = fiat_p384_addcarryx_u64(x95, x61, x83);
    let mut x98: u64 = 0;
    let mut x99: fiat_p384_u1 = 0;
    let (x98, x99) = fiat_p384_addcarryx_u64(x97, x63, x85);
    let mut x100: u64 = 0;
    let mut x101: fiat_p384_u1 = 0;
    let (x100, x101) = fiat_p384_addcarryx_u64(x99, x65, x87);
    let mut x102: u64 = 0;
    let mut x103: fiat_p384_u1 = 0;
    let (x102, x103) = fiat_p384_addcarryx_u64(x101, x67, x89);
    let mut x104: u64 = 0;
    let mut x105: fiat_p384_u1 = 0;
    let (x104, x105) = fiat_p384_addcarryx_u64(x103, (x68 as u64), x91);
    let mut x106: u64 = 0;
    let mut x107: u64 = 0;
    let (x106, x107) = fiat_p384_mulx_u64(x92, 0x100000001);
    let mut x108: u64 = 0;
    let mut x109: u64 = 0;
    let (x108, x109) = fiat_p384_mulx_u64(x106, 0xffffffffffffffff);
    let mut x110: u64 = 0;
    let mut x111: u64 = 0;
    let (x110, x111) = fiat_p384_mulx_u64(x106, 0xffffffffffffffff);
    let mut x112: u64 = 0;
    let mut x113: u64 = 0;
    let (x112, x113) = fiat_p384_mulx_u64(x106, 0xffffffffffffffff);
    let mut x114: u64 = 0;
    let mut x115: u64 = 0;
    let (x114, x115) = fiat_p384_mulx_u64(x106, 0xfffffffffffffffe);
    let mut x116: u64 = 0;
    let mut x117: u64 = 0;
    let (x116, x117) = fiat_p384_mulx_u64(x106, 0xffffffff00000000);
    let mut x118: u64 = 0;
    let mut x119: u64 = 0;
    let (x118, x119) = fiat_p384_mulx_u64(x106, 0xffffffff);
    let mut x120: u64 = 0;
    let mut x121: fiat_p384_u1 = 0;
    let (x120, x121) = fiat_p384_addcarryx_u64(0x0, x119, x116);
    let mut x122: u64 = 0;
    let mut x123: fiat_p384_u1 = 0;
    let (x122, x123) = fiat_p384_addcarryx_u64(x121, x117, x114);
    let mut x124: u64 = 0;
    let mut x125: fiat_p384_u1 = 0;
    let (x124, x125) = fiat_p384_addcarryx_u64(x123, x115, x112);
    let mut x126: u64 = 0;
    let mut x127: fiat_p384_u1 = 0;
    let (x126, x127) = fiat_p384_addcarryx_u64(x125, x113, x110);
    let mut x128: u64 = 0;
    let mut x129: fiat_p384_u1 = 0;
    let (x128, x129) = fiat_p384_addcarryx_u64(x127, x111, x108);
    let x130: u64 = ((x129 as u64) + x109);
    let mut x131: u64 = 0;
    let mut x132: fiat_p384_u1 = 0;
    let (x131, x132) = fiat_p384_addcarryx_u64(0x0, x92, x118);
    let mut x133: u64 = 0;
    let mut x134: fiat_p384_u1 = 0;
    let (x133, x134) = fiat_p384_addcarryx_u64(x132, x94, x120);
    let mut x135: u64 = 0;
    let mut x136: fiat_p384_u1 = 0;
    let (x135, x136) = fiat_p384_addcarryx_u64(x134, x96, x122);
    let mut x137: u64 = 0;
    let mut x138: fiat_p384_u1 = 0;
    let (x137, x138) = fiat_p384_addcarryx_u64(x136, x98, x124);
    let mut x139: u64 = 0;
    let mut x140: fiat_p384_u1 = 0;
    let (x139, x140) = fiat_p384_addcarryx_u64(x138, x100, x126);
    let mut x141: u64 = 0;
    let mut x142: fiat_p384_u1 = 0;
    let (x141, x142) = fiat_p384_addcarryx_u64(x140, x102, x128);
    let mut x143: u64 = 0;
    let mut x144: fiat_p384_u1 = 0;
    let (x143, x144) = fiat_p384_addcarryx_u64(x142, x104, x130);
    let x145: u64 = ((x144 as u64) + (x105 as u64));
    let mut x146: u64 = 0;
    let mut x147: u64 = 0;
    let (x146, x147) = fiat_p384_mulx_u64(x2, (arg1[5]));
    let mut x148: u64 = 0;
    let mut x149: u64 = 0;
    let (x148, x149) = fiat_p384_mulx_u64(x2, (arg1[4]));
    let mut x150: u64 = 0;
    let mut x151: u64 = 0;
    let (x150, x151) = fiat_p384_mulx_u64(x2, (arg1[3]));
    let mut x152: u64 = 0;
    let mut x153: u64 = 0;
    let (x152, x153) = fiat_p384_mulx_u64(x2, (arg1[2]));
    let mut x154: u64 = 0;
    let mut x155: u64 = 0;
    let (x154, x155) = fiat_p384_mulx_u64(x2, (arg1[1]));
    let mut x156: u64 = 0;
    let mut x157: u64 = 0;
    let (x156, x157) = fiat_p384_mulx_u64(x2, (arg1[0]));
    let mut x158: u64 = 0;
    let mut x159: fiat_p384_u1 = 0;
    let (x158, x159) = fiat_p384_addcarryx_u64(0x0, x157, x154);
    let mut x160: u64 = 0;
    let mut x161: fiat_p384_u1 = 0;
    let (x160, x161) = fiat_p384_addcarryx_u64(x159, x155, x152);
    let mut x162: u64 = 0;
    let mut x163: fiat_p384_u1 = 0;
    let (x162, x163) = fiat_p384_addcarryx_u64(x161, x153, x150);
    let mut x164: u64 = 0;
    let mut x165: fiat_p384_u1 = 0;
    let (x164, x165) = fiat_p384_addcarryx_u64(x163, x151, x148);
    let mut x166: u64 = 0;
    let mut x167: fiat_p384_u1 = 0;
    let (x166, x167) = fiat_p384_addcarryx_u64(x165, x149, x146);
    let x168: u64 = ((x167 as u64) + x147);
    let mut x169: u64 = 0;
    let mut x170: fiat_p384_u1 = 0;
    let (x169, x170) = fiat_p384_addcarryx_u64(0x0, x133, x156);
    let mut x171: u64 = 0;
    let mut x172: fiat_p384_u1 = 0;
    let (x171, x172) = fiat_p384_addcarryx_u64(x170, x135, x158);
    let mut x173: u64 = 0;
    let mut x174: fiat_p384_u1 = 0;
    let (x173, x174) = fiat_p384_addcarryx_u64(x172, x137, x160);
    let mut x175: u64 = 0;
    let mut x176: fiat_p384_u1 = 0;
    let (x175, x176) = fiat_p384_addcarryx_u64(x174, x139, x162);
    let mut x177: u64 = 0;
    let mut x178: fiat_p384_u1 = 0;
    let (x177, x178) = fiat_p384_addcarryx_u64(x176, x141, x164);
    let mut x179: u64 = 0;
    let mut x180: fiat_p384_u1 = 0;
    let (x179, x180) = fiat_p384_addcarryx_u64(x178, x143, x166);
    let mut x181: u64 = 0;
    let mut x182: fiat_p384_u1 = 0;
    let (x181, x182) = fiat_p384_addcarryx_u64(x180, x145, x168);
    let mut x183: u64 = 0;
    let mut x184: u64 = 0;
    let (x183, x184) = fiat_p384_mulx_u64(x169, 0x100000001);
    let mut x185: u64 = 0;
    let mut x186: u64 = 0;
    let (x185, x186) = fiat_p384_mulx_u64(x183, 0xffffffffffffffff);
    let mut x187: u64 = 0;
    let mut x188: u64 = 0;
    let (x187, x188) = fiat_p384_mulx_u64(x183, 0xffffffffffffffff);
    let mut x189: u64 = 0;
    let mut x190: u64 = 0;
    let (x189, x190) = fiat_p384_mulx_u64(x183, 0xffffffffffffffff);
    let mut x191: u64 = 0;
    let mut x192: u64 = 0;
    let (x191, x192) = fiat_p384_mulx_u64(x183, 0xfffffffffffffffe);
    let mut x193: u64 = 0;
    let mut x194: u64 = 0;
    let (x193, x194) = fiat_p384_mulx_u64(x183, 0xffffffff00000000);
    let mut x195: u64 = 0;
    let mut x196: u64 = 0;
    let (x195, x196) = fiat_p384_mulx_u64(x183, 0xffffffff);
    let mut x197: u64 = 0;
    let mut x198: fiat_p384_u1 = 0;
    let (x197, x198) = fiat_p384_addcarryx_u64(0x0, x196, x193);
    let mut x199: u64 = 0;
    let mut x200: fiat_p384_u1 = 0;
    let (x199, x200) = fiat_p384_addcarryx_u64(x198, x194, x191);
    let mut x201: u64 = 0;
    let mut x202: fiat_p384_u1 = 0;
    let (x201, x202) = fiat_p384_addcarryx_u64(x200, x192, x189);
    let mut x203: u64 = 0;
    let mut x204: fiat_p384_u1 = 0;
    let (x203, x204) = fiat_p384_addcarryx_u64(x202, x190, x187);
    let mut x205: u64 = 0;
    let mut x206: fiat_p384_u1 = 0;
    let (x205, x206) = fiat_p384_addcarryx_u64(x204, x188, x185);
    let x207: u64 = ((x206 as u64) + x186);
    let mut x208: u64 = 0;
    let mut x209: fiat_p384_u1 = 0;
    let (x208, x209) = fiat_p384_addcarryx_u64(0x0, x169, x195);
    let mut x210: u64 = 0;
    let mut x211: fiat_p384_u1 = 0;
    let (x210, x211) = fiat_p384_addcarryx_u64(x209, x171, x197);
    let mut x212: u64 = 0;
    let mut x213: fiat_p384_u1 = 0;
    let (x212, x213) = fiat_p384_addcarryx_u64(x211, x173, x199);
    let mut x214: u64 = 0;
    let mut x215: fiat_p384_u1 = 0;
    let (x214, x215) = fiat_p384_addcarryx_u64(x213, x175, x201);
    let mut x216: u64 = 0;
    let mut x217: fiat_p384_u1 = 0;
    let (x216, x217) = fiat_p384_addcarryx_u64(x215, x177, x203);
    let mut x218: u64 = 0;
    let mut x219: fiat_p384_u1 = 0;
    let (x218, x219) = fiat_p384_addcarryx_u64(x217, x179, x205);
    let mut x220: u64 = 0;
    let mut x221: fiat_p384_u1 = 0;
    let (x220, x221) = fiat_p384_addcarryx_u64(x219, x181, x207);
    let x222: u64 = ((x221 as u64) + (x182 as u64));
    let mut x223: u64 = 0;
    let mut x224: u64 = 0;
    let (x223, x224) = fiat_p384_mulx_u64(x3, (arg1[5]));
    let mut x225: u64 = 0;
    let mut x226: u64 = 0;
    let (x225, x226) = fiat_p384_mulx_u64(x3, (arg1[4]));
    let mut x227: u64 = 0;
    let mut x228: u64 = 0;
    let (x227, x228) = fiat_p384_mulx_u64(x3, (arg1[3]));
    let mut x229: u64 = 0;
    let mut x230: u64 = 0;
    let (x229, x230) = fiat_p384_mulx_u64(x3, (arg1[2]));
    let mut x231: u64 = 0;
    let mut x232: u64 = 0;
    let (x231, x232) = fiat_p384_mulx_u64(x3, (arg1[1]));
    let mut x233: u64 = 0;
    let mut x234: u64 = 0;
    let (x233, x234) = fiat_p384_mulx_u64(x3, (arg1[0]));
    let mut x235: u64 = 0;
    let mut x236: fiat_p384_u1 = 0;
    let (x235, x236) = fiat_p384_addcarryx_u64(0x0, x234, x231);
    let mut x237: u64 = 0;
    let mut x238: fiat_p384_u1 = 0;
    let (x237, x238) = fiat_p384_addcarryx_u64(x236, x232, x229);
    let mut x239: u64 = 0;
    let mut x240: fiat_p384_u1 = 0;
    let (x239, x240) = fiat_p384_addcarryx_u64(x238, x230, x227);
    let mut x241: u64 = 0;
    let mut x242: fiat_p384_u1 = 0;
    let (x241, x242) = fiat_p384_addcarryx_u64(x240, x228, x225);
    let mut x243: u64 = 0;
    let mut x244: fiat_p384_u1 = 0;
    let (x243, x244) = fiat_p384_addcarryx_u64(x242, x226, x223);
    let x245: u64 = ((x244 as u64) + x224);
    let mut x246: u64 = 0;
    let mut x247: fiat_p384_u1 = 0;
    let (x246, x247) = fiat_p384_addcarryx_u64(0x0, x210, x233);
    let mut x248: u64 = 0;
    let mut x249: fiat_p384_u1 = 0;
    let (x248, x249) = fiat_p384_addcarryx_u64(x247, x212, x235);
    let mut x250: u64 = 0;
    let mut x251: fiat_p384_u1 = 0;
    let (x250, x251) = fiat_p384_addcarryx_u64(x249, x214, x237);
    let mut x252: u64 = 0;
    let mut x253: fiat_p384_u1 = 0;
    let (x252, x253) = fiat_p384_addcarryx_u64(x251, x216, x239);
    let mut x254: u64 = 0;
    let mut x255: fiat_p384_u1 = 0;
    let (x254, x255) = fiat_p384_addcarryx_u64(x253, x218, x241);
    let mut x256: u64 = 0;
    let mut x257: fiat_p384_u1 = 0;
    let (x256, x257) = fiat_p384_addcarryx_u64(x255, x220, x243);
    let mut x258: u64 = 0;
    let mut x259: fiat_p384_u1 = 0;
    let (x258, x259) = fiat_p384_addcarryx_u64(x257, x222, x245);
    let mut x260: u64 = 0;
    let mut x261: u64 = 0;
    let (x260, x261) = fiat_p384_mulx_u64(x246, 0x100000001);
    let mut x262: u64 = 0;
    let mut x263: u64 = 0;
    let (x262, x263) = fiat_p384_mulx_u64(x260, 0xffffffffffffffff);
    let mut x264: u64 = 0;
    let mut x265: u64 = 0;
    let (x264, x265) = fiat_p384_mulx_u64(x260, 0xffffffffffffffff);
    let mut x266: u64 = 0;
    let mut x267: u64 = 0;
    let (x266, x267) = fiat_p384_mulx_u64(x260, 0xffffffffffffffff);
    let mut x268: u64 = 0;
    let mut x269: u64 = 0;
    let (x268, x269) = fiat_p384_mulx_u64(x260, 0xfffffffffffffffe);
    let mut x270: u64 = 0;
    let mut x271: u64 = 0;
    let (x270, x271) = fiat_p384_mulx_u64(x260, 0xffffffff00000000);
    let mut x272: u64 = 0;
    let mut x273: u64 = 0;
    let (x272, x273) = fiat_p384_mulx_u64(x260, 0xffffffff);
    let mut x274: u64 = 0;
    let mut x275: fiat_p384_u1 = 0;
    let (x274, x275) = fiat_p384_addcarryx_u64(0x0, x273, x270);
    let mut x276: u64 = 0;
    let mut x277: fiat_p384_u1 = 0;
    let (x276, x277) = fiat_p384_addcarryx_u64(x275, x271, x268);
    let mut x278: u64 = 0;
    let mut x279: fiat_p384_u1 = 0;
    let (x278, x279) = fiat_p384_addcarryx_u64(x277, x269, x266);
    let mut x280: u64 = 0;
    let mut x281: fiat_p384_u1 = 0;
    let (x280, x281) = fiat_p384_addcarryx_u64(x279, x267, x264);
    let mut x282: u64 = 0;
    let mut x283: fiat_p384_u1 = 0;
    let (x282, x283) = fiat_p384_addcarryx_u64(x281, x265, x262);
    let x284: u64 = ((x283 as u64) + x263);
    let mut x285: u64 = 0;
    let mut x286: fiat_p384_u1 = 0;
    let (x285, x286) = fiat_p384_addcarryx_u64(0x0, x246, x272);
    let mut x287: u64 = 0;
    let mut x288: fiat_p384_u1 = 0;
    let (x287, x288) = fiat_p384_addcarryx_u64(x286, x248, x274);
    let mut x289: u64 = 0;
    let mut x290: fiat_p384_u1 = 0;
    let (x289, x290) = fiat_p384_addcarryx_u64(x288, x250, x276);
    let mut x291: u64 = 0;
    let mut x292: fiat_p384_u1 = 0;
    let (x291, x292) = fiat_p384_addcarryx_u64(x290, x252, x278);
    let mut x293: u64 = 0;
    let mut x294: fiat_p384_u1 = 0;
    let (x293, x294) = fiat_p384_addcarryx_u64(x292, x254, x280);
    let mut x295: u64 = 0;
    let mut x296: fiat_p384_u1 = 0;
    let (x295, x296) = fiat_p384_addcarryx_u64(x294, x256, x282);
    let mut x297: u64 = 0;
    let mut x298: fiat_p384_u1 = 0;
    let (x297, x298) = fiat_p384_addcarryx_u64(x296, x258, x284);
    let x299: u64 = ((x298 as u64) + (x259 as u64));
    let mut x300: u64 = 0;
    let mut x301: u64 = 0;
    let (x300, x301) = fiat_p384_mulx_u64(x4, (arg1[5]));
    let mut x302: u64 = 0;
    let mut x303: u64 = 0;
    let (x302, x303) = fiat_p384_mulx_u64(x4, (arg1[4]));
    let mut x304: u64 = 0;
    let mut x305: u64 = 0;
    let (x304, x305) = fiat_p384_mulx_u64(x4, (arg1[3]));
    let mut x306: u64 = 0;
    let mut x307: u64 = 0;
    let (x306, x307) = fiat_p384_mulx_u64(x4, (arg1[2]));
    let mut x308: u64 = 0;
    let mut x309: u64 = 0;
    let (x308, x309) = fiat_p384_mulx_u64(x4, (arg1[1]));
    let mut x310: u64 = 0;
    let mut x311: u64 = 0;
    let (x310, x311) = fiat_p384_mulx_u64(x4, (arg1[0]));
    let mut x312: u64 = 0;
    let mut x313: fiat_p384_u1 = 0;
    let (x312, x313) = fiat_p384_addcarryx_u64(0x0, x311, x308);
    let mut x314: u64 = 0;
    let mut x315: fiat_p384_u1 = 0;
    let (x314, x315) = fiat_p384_addcarryx_u64(x313, x309, x306);
    let mut x316: u64 = 0;
    let mut x317: fiat_p384_u1 = 0;
    let (x316, x317) = fiat_p384_addcarryx_u64(x315, x307, x304);
    let mut x318: u64 = 0;
    let mut x319: fiat_p384_u1 = 0;
    let (x318, x319) = fiat_p384_addcarryx_u64(x317, x305, x302);
    let mut x320: u64 = 0;
    let mut x321: fiat_p384_u1 = 0;
    let (x320, x321) = fiat_p384_addcarryx_u64(x319, x303, x300);
    let x322: u64 = ((x321 as u64) + x301);
    let mut x323: u64 = 0;
    let mut x324: fiat_p384_u1 = 0;
    let (x323, x324) = fiat_p384_addcarryx_u64(0x0, x287, x310);
    let mut x325: u64 = 0;
    let mut x326: fiat_p384_u1 = 0;
    let (x325, x326) = fiat_p384_addcarryx_u64(x324, x289, x312);
    let mut x327: u64 = 0;
    let mut x328: fiat_p384_u1 = 0;
    let (x327, x328) = fiat_p384_addcarryx_u64(x326, x291, x314);
    let mut x329: u64 = 0;
    let mut x330: fiat_p384_u1 = 0;
    let (x329, x330) = fiat_p384_addcarryx_u64(x328, x293, x316);
    let mut x331: u64 = 0;
    let mut x332: fiat_p384_u1 = 0;
    let (x331, x332) = fiat_p384_addcarryx_u64(x330, x295, x318);
    let mut x333: u64 = 0;
    let mut x334: fiat_p384_u1 = 0;
    let (x333, x334) = fiat_p384_addcarryx_u64(x332, x297, x320);
    let mut x335: u64 = 0;
    let mut x336: fiat_p384_u1 = 0;
    let (x335, x336) = fiat_p384_addcarryx_u64(x334, x299, x322);
    let mut x337: u64 = 0;
    let mut x338: u64 = 0;
    let (x337, x338) = fiat_p384_mulx_u64(x323, 0x100000001);
    let mut x339: u64 = 0;
    let mut x340: u64 = 0;
    let (x339, x340) = fiat_p384_mulx_u64(x337, 0xffffffffffffffff);
    let mut x341: u64 = 0;
    let mut x342: u64 = 0;
    let (x341, x342) = fiat_p384_mulx_u64(x337, 0xffffffffffffffff);
    let mut x343: u64 = 0;
    let mut x344: u64 = 0;
    let (x343, x344) = fiat_p384_mulx_u64(x337, 0xffffffffffffffff);
    let mut x345: u64 = 0;
    let mut x346: u64 = 0;
    let (x345, x346) = fiat_p384_mulx_u64(x337, 0xfffffffffffffffe);
    let mut x347: u64 = 0;
    let mut x348: u64 = 0;
    let (x347, x348) = fiat_p384_mulx_u64(x337, 0xffffffff00000000);
    let mut x349: u64 = 0;
    let mut x350: u64 = 0;
    let (x349, x350) = fiat_p384_mulx_u64(x337, 0xffffffff);
    let mut x351: u64 = 0;
    let mut x352: fiat_p384_u1 = 0;
    let (x351, x352) = fiat_p384_addcarryx_u64(0x0, x350, x347);
    let mut x353: u64 = 0;
    let mut x354: fiat_p384_u1 = 0;
    let (x353, x354) = fiat_p384_addcarryx_u64(x352, x348, x345);
    let mut x355: u64 = 0;
    let mut x356: fiat_p384_u1 = 0;
    let (x355, x356) = fiat_p384_addcarryx_u64(x354, x346, x343);
    let mut x357: u64 = 0;
    let mut x358: fiat_p384_u1 = 0;
    let (x357, x358) = fiat_p384_addcarryx_u64(x356, x344, x341);
    let mut x359: u64 = 0;
    let mut x360: fiat_p384_u1 = 0;
    let (x359, x360) = fiat_p384_addcarryx_u64(x358, x342, x339);
    let x361: u64 = ((x360 as u64) + x340);
    let mut x362: u64 = 0;
    let mut x363: fiat_p384_u1 = 0;
    let (x362, x363) = fiat_p384_addcarryx_u64(0x0, x323, x349);
    let mut x364: u64 = 0;
    let mut x365: fiat_p384_u1 = 0;
    let (x364, x365) = fiat_p384_addcarryx_u64(x363, x325, x351);
    let mut x366: u64 = 0;
    let mut x367: fiat_p384_u1 = 0;
    let (x366, x367) = fiat_p384_addcarryx_u64(x365, x327, x353);
    let mut x368: u64 = 0;
    let mut x369: fiat_p384_u1 = 0;
    let (x368, x369) = fiat_p384_addcarryx_u64(x367, x329, x355);
    let mut x370: u64 = 0;
    let mut x371: fiat_p384_u1 = 0;
    let (x370, x371) = fiat_p384_addcarryx_u64(x369, x331, x357);
    let mut x372: u64 = 0;
    let mut x373: fiat_p384_u1 = 0;
    let (x372, x373) = fiat_p384_addcarryx_u64(x371, x333, x359);
    let mut x374: u64 = 0;
    let mut x375: fiat_p384_u1 = 0;
    let (x374, x375) = fiat_p384_addcarryx_u64(x373, x335, x361);
    let x376: u64 = ((x375 as u64) + (x336 as u64));
    let mut x377: u64 = 0;
    let mut x378: u64 = 0;
    let (x377, x378) = fiat_p384_mulx_u64(x5, (arg1[5]));
    let mut x379: u64 = 0;
    let mut x380: u64 = 0;
    let (x379, x380) = fiat_p384_mulx_u64(x5, (arg1[4]));
    let mut x381: u64 = 0;
    let mut x382: u64 = 0;
    let (x381, x382) = fiat_p384_mulx_u64(x5, (arg1[3]));
    let mut x383: u64 = 0;
    let mut x384: u64 = 0;
    let (x383, x384) = fiat_p384_mulx_u64(x5, (arg1[2]));
    let mut x385: u64 = 0;
    let mut x386: u64 = 0;
    let (x385, x386) = fiat_p384_mulx_u64(x5, (arg1[1]));
    let mut x387: u64 = 0;
    let mut x388: u64 = 0;
    let (x387, x388) = fiat_p384_mulx_u64(x5, (arg1[0]));
    let mut x389: u64 = 0;
    let mut x390: fiat_p384_u1 = 0;
    let (x389, x390) = fiat_p384_addcarryx_u64(0x0, x388, x385);
    let mut x391: u64 = 0;
    let mut x392: fiat_p384_u1 = 0;
    let (x391, x392) = fiat_p384_addcarryx_u64(x390, x386, x383);
    let mut x393: u64 = 0;
    let mut x394: fiat_p384_u1 = 0;
    let (x393, x394) = fiat_p384_addcarryx_u64(x392, x384, x381);
    let mut x395: u64 = 0;
    let mut x396: fiat_p384_u1 = 0;
    let (x395, x396) = fiat_p384_addcarryx_u64(x394, x382, x379);
    let mut x397: u64 = 0;
    let mut x398: fiat_p384_u1 = 0;
    let (x397, x398) = fiat_p384_addcarryx_u64(x396, x380, x377);
    let x399: u64 = ((x398 as u64) + x378);
    let mut x400: u64 = 0;
    let mut x401: fiat_p384_u1 = 0;
    let (x400, x401) = fiat_p384_addcarryx_u64(0x0, x364, x387);
    let mut x402: u64 = 0;
    let mut x403: fiat_p384_u1 = 0;
    let (x402, x403) = fiat_p384_addcarryx_u64(x401, x366, x389);
    let mut x404: u64 = 0;
    let mut x405: fiat_p384_u1 = 0;
    let (x404, x405) = fiat_p384_addcarryx_u64(x403, x368, x391);
    let mut x406: u64 = 0;
    let mut x407: fiat_p384_u1 = 0;
    let (x406, x407) = fiat_p384_addcarryx_u64(x405, x370, x393);
    let mut x408: u64 = 0;
    let mut x409: fiat_p384_u1 = 0;
    let (x408, x409) = fiat_p384_addcarryx_u64(x407, x372, x395);
    let mut x410: u64 = 0;
    let mut x411: fiat_p384_u1 = 0;
    let (x410, x411) = fiat_p384_addcarryx_u64(x409, x374, x397);
    let mut x412: u64 = 0;
    let mut x413: fiat_p384_u1 = 0;
    let (x412, x413) = fiat_p384_addcarryx_u64(x411, x376, x399);
    let mut x414: u64 = 0;
    let mut x415: u64 = 0;
    let (x414, x415) = fiat_p384_mulx_u64(x400, 0x100000001);
    let mut x416: u64 = 0;
    let mut x417: u64 = 0;
    let (x416, x417) = fiat_p384_mulx_u64(x414, 0xffffffffffffffff);
    let mut x418: u64 = 0;
    let mut x419: u64 = 0;
    let (x418, x419) = fiat_p384_mulx_u64(x414, 0xffffffffffffffff);
    let mut x420: u64 = 0;
    let mut x421: u64 = 0;
    let (x420, x421) = fiat_p384_mulx_u64(x414, 0xffffffffffffffff);
    let mut x422: u64 = 0;
    let mut x423: u64 = 0;
    let (x422, x423) = fiat_p384_mulx_u64(x414, 0xfffffffffffffffe);
    let mut x424: u64 = 0;
    let mut x425: u64 = 0;
    let (x424, x425) = fiat_p384_mulx_u64(x414, 0xffffffff00000000);
    let mut x426: u64 = 0;
    let mut x427: u64 = 0;
    let (x426, x427) = fiat_p384_mulx_u64(x414, 0xffffffff);
    let mut x428: u64 = 0;
    let mut x429: fiat_p384_u1 = 0;
    let (x428, x429) = fiat_p384_addcarryx_u64(0x0, x427, x424);
    let mut x430: u64 = 0;
    let mut x431: fiat_p384_u1 = 0;
    let (x430, x431) = fiat_p384_addcarryx_u64(x429, x425, x422);
    let mut x432: u64 = 0;
    let mut x433: fiat_p384_u1 = 0;
    let (x432, x433) = fiat_p384_addcarryx_u64(x431, x423, x420);
    let mut x434: u64 = 0;
    let mut x435: fiat_p384_u1 = 0;
    let (x434, x435) = fiat_p384_addcarryx_u64(x433, x421, x418);
    let mut x436: u64 = 0;
    let mut x437: fiat_p384_u1 = 0;
    let (x436, x437) = fiat_p384_addcarryx_u64(x435, x419, x416);
    let x438: u64 = ((x437 as u64) + x417);
    let mut x439: u64 = 0;
    let mut x440: fiat_p384_u1 = 0;
    let (x439, x440) = fiat_p384_addcarryx_u64(0x0, x400, x426);
    let mut x441: u64 = 0;
    let mut x442: fiat_p384_u1 = 0;
    let (x441, x442) = fiat_p384_addcarryx_u64(x440, x402, x428);
    let mut x443: u64 = 0;
    let mut x444: fiat_p384_u1 = 0;
    let (x443, x444) = fiat_p384_addcarryx_u64(x442, x404, x430);
    let mut x445: u64 = 0;
    let mut x446: fiat_p384_u1 = 0;
    let (x445, x446) = fiat_p384_addcarryx_u64(x444, x406, x432);
    let mut x447: u64 = 0;
    let mut x448: fiat_p384_u1 = 0;
    let (x447, x448) = fiat_p384_addcarryx_u64(x446, x408, x434);
    let mut x449: u64 = 0;
    let mut x450: fiat_p384_u1 = 0;
    let (x449, x450) = fiat_p384_addcarryx_u64(x448, x410, x436);
    let mut x451: u64 = 0;
    let mut x452: fiat_p384_u1 = 0;
    let (x451, x452) = fiat_p384_addcarryx_u64(x450, x412, x438);
    let x453: u64 = ((x452 as u64) + (x413 as u64));
    let mut x454: u64 = 0;
    let mut x455: fiat_p384_u1 = 0;
    let (x454, x455) = fiat_p384_subborrowx_u64(0x0, x441, 0xffffffff);
    let mut x456: u64 = 0;
    let mut x457: fiat_p384_u1 = 0;
    let (x456, x457) = fiat_p384_subborrowx_u64(x455, x443, 0xffffffff00000000);
    let mut x458: u64 = 0;
    let mut x459: fiat_p384_u1 = 0;
    let (x458, x459) = fiat_p384_subborrowx_u64(x457, x445, 0xfffffffffffffffe);
    let mut x460: u64 = 0;
    let mut x461: fiat_p384_u1 = 0;
    let (x460, x461) = fiat_p384_subborrowx_u64(x459, x447, 0xffffffffffffffff);
    let mut x462: u64 = 0;
    let mut x463: fiat_p384_u1 = 0;
    let (x462, x463) = fiat_p384_subborrowx_u64(x461, x449, 0xffffffffffffffff);
    let mut x464: u64 = 0;
    let mut x465: fiat_p384_u1 = 0;
    let (x464, x465) = fiat_p384_subborrowx_u64(x463, x451, 0xffffffffffffffff);
    let mut x466: u64 = 0;
    let mut x467: fiat_p384_u1 = 0;
    let (x466, x467) = fiat_p384_subborrowx_u64(x465, x453, (0x0 as u64));
    let mut x468: u64 = 0;
    let (x468) = fiat_p384_cmovznz_u64(x467, x454, x441);
    let mut x469: u64 = 0;
    let (x469) = fiat_p384_cmovznz_u64(x467, x456, x443);
    let mut x470: u64 = 0;
    let (x470) = fiat_p384_cmovznz_u64(x467, x458, x445);
    let mut x471: u64 = 0;
    let (x471) = fiat_p384_cmovznz_u64(x467, x460, x447);
    let mut x472: u64 = 0;
    let (x472) = fiat_p384_cmovznz_u64(x467, x462, x449);
    let mut x473: u64 = 0;
    let (x473) = fiat_p384_cmovznz_u64(x467, x464, x451);
    out1[0] = x468;
    out1[1] = x469;
    out1[2] = x470;
    out1[3] = x471;
    out1[4] = x472;
    out1[5] = x473;
    out1
}
#[doc = " The function fiat_p384_add adds two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) + eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_add(
    arg1: &fiat_p384_montgomery_domain_field_element,
    arg2: &fiat_p384_montgomery_domain_field_element,
) -> fiat_p384_montgomery_domain_field_element {
    let mut out1: fiat_p384_montgomery_domain_field_element = [0; 6];
    let mut x1: u64 = 0;
    let mut x2: fiat_p384_u1 = 0;
    let (x1, x2) = fiat_p384_addcarryx_u64(0x0, (arg1[0]), (arg2[0]));
    let mut x3: u64 = 0;
    let mut x4: fiat_p384_u1 = 0;
    let (x3, x4) = fiat_p384_addcarryx_u64(x2, (arg1[1]), (arg2[1]));
    let mut x5: u64 = 0;
    let mut x6: fiat_p384_u1 = 0;
    let (x5, x6) = fiat_p384_addcarryx_u64(x4, (arg1[2]), (arg2[2]));
    let mut x7: u64 = 0;
    let mut x8: fiat_p384_u1 = 0;
    let (x7, x8) = fiat_p384_addcarryx_u64(x6, (arg1[3]), (arg2[3]));
    let mut x9: u64 = 0;
    let mut x10: fiat_p384_u1 = 0;
    let (x9, x10) = fiat_p384_addcarryx_u64(x8, (arg1[4]), (arg2[4]));
    let mut x11: u64 = 0;
    let mut x12: fiat_p384_u1 = 0;
    let (x11, x12) = fiat_p384_addcarryx_u64(x10, (arg1[5]), (arg2[5]));
    let mut x13: u64 = 0;
    let mut x14: fiat_p384_u1 = 0;
    let (x13, x14) = fiat_p384_subborrowx_u64(0x0, x1, 0xffffffff);
    let mut x15: u64 = 0;
    let mut x16: fiat_p384_u1 = 0;
    let (x15, x16) = fiat_p384_subborrowx_u64(x14, x3, 0xffffffff00000000);
    let mut x17: u64 = 0;
    let mut x18: fiat_p384_u1 = 0;
    let (x17, x18) = fiat_p384_subborrowx_u64(x16, x5, 0xfffffffffffffffe);
    let mut x19: u64 = 0;
    let mut x20: fiat_p384_u1 = 0;
    let (x19, x20) = fiat_p384_subborrowx_u64(x18, x7, 0xffffffffffffffff);
    let mut x21: u64 = 0;
    let mut x22: fiat_p384_u1 = 0;
    let (x21, x22) = fiat_p384_subborrowx_u64(x20, x9, 0xffffffffffffffff);
    let mut x23: u64 = 0;
    let mut x24: fiat_p384_u1 = 0;
    let (x23, x24) = fiat_p384_subborrowx_u64(x22, x11, 0xffffffffffffffff);
    let mut x25: u64 = 0;
    let mut x26: fiat_p384_u1 = 0;
    let (x25, x26) = fiat_p384_subborrowx_u64(x24, (x12 as u64), (0x0 as u64));
    let mut x27: u64 = 0;
    let (x27) = fiat_p384_cmovznz_u64(x26, x13, x1);
    let mut x28: u64 = 0;
    let (x28) = fiat_p384_cmovznz_u64(x26, x15, x3);
    let mut x29: u64 = 0;
    let (x29) = fiat_p384_cmovznz_u64(x26, x17, x5);
    let mut x30: u64 = 0;
    let (x30) = fiat_p384_cmovznz_u64(x26, x19, x7);
    let mut x31: u64 = 0;
    let (x31) = fiat_p384_cmovznz_u64(x26, x21, x9);
    let mut x32: u64 = 0;
    let (x32) = fiat_p384_cmovznz_u64(x26, x23, x11);
    out1[0] = x27;
    out1[1] = x28;
    out1[2] = x29;
    out1[3] = x30;
    out1[4] = x31;
    out1[5] = x32;
    out1
}
#[doc = " The function fiat_p384_sub subtracts two field elements in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = "   0 ≤ eval arg2 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = (eval (from_montgomery arg1) - eval (from_montgomery arg2)) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_sub(
    arg1: &fiat_p384_montgomery_domain_field_element,
    arg2: &fiat_p384_montgomery_domain_field_element,
) -> fiat_p384_montgomery_domain_field_element {
    let mut out1: fiat_p384_montgomery_domain_field_element = [0; 6];
    let mut x1: u64 = 0;
    let mut x2: fiat_p384_u1 = 0;
    let (x1, x2) = fiat_p384_subborrowx_u64(0x0, (arg1[0]), (arg2[0]));
    let mut x3: u64 = 0;
    let mut x4: fiat_p384_u1 = 0;
    let (x3, x4) = fiat_p384_subborrowx_u64(x2, (arg1[1]), (arg2[1]));
    let mut x5: u64 = 0;
    let mut x6: fiat_p384_u1 = 0;
    let (x5, x6) = fiat_p384_subborrowx_u64(x4, (arg1[2]), (arg2[2]));
    let mut x7: u64 = 0;
    let mut x8: fiat_p384_u1 = 0;
    let (x7, x8) = fiat_p384_subborrowx_u64(x6, (arg1[3]), (arg2[3]));
    let mut x9: u64 = 0;
    let mut x10: fiat_p384_u1 = 0;
    let (x9, x10) = fiat_p384_subborrowx_u64(x8, (arg1[4]), (arg2[4]));
    let mut x11: u64 = 0;
    let mut x12: fiat_p384_u1 = 0;
    let (x11, x12) = fiat_p384_subborrowx_u64(x10, (arg1[5]), (arg2[5]));
    let mut x13: u64 = 0;
    let (x13) = fiat_p384_cmovznz_u64(x12, (0x0 as u64), 0xffffffffffffffff);
    let mut x14: u64 = 0;
    let mut x15: fiat_p384_u1 = 0;
    let (x14, x15) = fiat_p384_addcarryx_u64(0x0, x1, (x13 & 0xffffffff));
    let mut x16: u64 = 0;
    let mut x17: fiat_p384_u1 = 0;
    let (x16, x17) = fiat_p384_addcarryx_u64(x15, x3, (x13 & 0xffffffff00000000));
    let mut x18: u64 = 0;
    let mut x19: fiat_p384_u1 = 0;
    let (x18, x19) = fiat_p384_addcarryx_u64(x17, x5, (x13 & 0xfffffffffffffffe));
    let mut x20: u64 = 0;
    let mut x21: fiat_p384_u1 = 0;
    let (x20, x21) = fiat_p384_addcarryx_u64(x19, x7, x13);
    let mut x22: u64 = 0;
    let mut x23: fiat_p384_u1 = 0;
    let (x22, x23) = fiat_p384_addcarryx_u64(x21, x9, x13);
    let mut x24: u64 = 0;
    let mut x25: fiat_p384_u1 = 0;
    let (x24, x25) = fiat_p384_addcarryx_u64(x23, x11, x13);
    out1[0] = x14;
    out1[1] = x16;
    out1[2] = x18;
    out1[3] = x20;
    out1[4] = x22;
    out1[5] = x24;
    out1
}
#[doc = " The function fiat_p384_opp negates a field element in the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = -eval (from_montgomery arg1) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_opp(
    arg1: &fiat_p384_montgomery_domain_field_element,
) -> fiat_p384_montgomery_domain_field_element {
    let mut out1: fiat_p384_montgomery_domain_field_element = [0; 6];
    let mut x1: u64 = 0;
    let mut x2: fiat_p384_u1 = 0;
    let (x1, x2) = fiat_p384_subborrowx_u64(0x0, (0x0 as u64), (arg1[0]));
    let mut x3: u64 = 0;
    let mut x4: fiat_p384_u1 = 0;
    let (x3, x4) = fiat_p384_subborrowx_u64(x2, (0x0 as u64), (arg1[1]));
    let mut x5: u64 = 0;
    let mut x6: fiat_p384_u1 = 0;
    let (x5, x6) = fiat_p384_subborrowx_u64(x4, (0x0 as u64), (arg1[2]));
    let mut x7: u64 = 0;
    let mut x8: fiat_p384_u1 = 0;
    let (x7, x8) = fiat_p384_subborrowx_u64(x6, (0x0 as u64), (arg1[3]));
    let mut x9: u64 = 0;
    let mut x10: fiat_p384_u1 = 0;
    let (x9, x10) = fiat_p384_subborrowx_u64(x8, (0x0 as u64), (arg1[4]));
    let mut x11: u64 = 0;
    let mut x12: fiat_p384_u1 = 0;
    let (x11, x12) = fiat_p384_subborrowx_u64(x10, (0x0 as u64), (arg1[5]));
    let mut x13: u64 = 0;
    let (x13) = fiat_p384_cmovznz_u64(x12, (0x0 as u64), 0xffffffffffffffff);
    let mut x14: u64 = 0;
    let mut x15: fiat_p384_u1 = 0;
    let (x14, x15) = fiat_p384_addcarryx_u64(0x0, x1, (x13 & 0xffffffff));
    let mut x16: u64 = 0;
    let mut x17: fiat_p384_u1 = 0;
    let (x16, x17) = fiat_p384_addcarryx_u64(x15, x3, (x13 & 0xffffffff00000000));
    let mut x18: u64 = 0;
    let mut x19: fiat_p384_u1 = 0;
    let (x18, x19) = fiat_p384_addcarryx_u64(x17, x5, (x13 & 0xfffffffffffffffe));
    let mut x20: u64 = 0;
    let mut x21: fiat_p384_u1 = 0;
    let (x20, x21) = fiat_p384_addcarryx_u64(x19, x7, x13);
    let mut x22: u64 = 0;
    let mut x23: fiat_p384_u1 = 0;
    let (x22, x23) = fiat_p384_addcarryx_u64(x21, x9, x13);
    let mut x24: u64 = 0;
    let mut x25: fiat_p384_u1 = 0;
    let (x24, x25) = fiat_p384_addcarryx_u64(x23, x11, x13);
    out1[0] = x14;
    out1[1] = x16;
    out1[2] = x18;
    out1[3] = x20;
    out1[4] = x22;
    out1[5] = x24;
    out1
}
#[doc = " The function fiat_p384_from_montgomery translates a field element out of the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval out1 mod m = (eval arg1 * ((2^64)⁻¹ mod m)^6) mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_from_montgomery(
    arg1: &fiat_p384_montgomery_domain_field_element,
) -> fiat_p384_non_montgomery_domain_field_element {
    let mut out1: fiat_p384_non_montgomery_domain_field_element = [0; 6];
    let x1: u64 = (arg1[0]);
    let mut x2: u64 = 0;
    let mut x3: u64 = 0;
    let (x2, x3) = fiat_p384_mulx_u64(x1, 0x100000001);
    let mut x4: u64 = 0;
    let mut x5: u64 = 0;
    let (x4, x5) = fiat_p384_mulx_u64(x2, 0xffffffffffffffff);
    let mut x6: u64 = 0;
    let mut x7: u64 = 0;
    let (x6, x7) = fiat_p384_mulx_u64(x2, 0xffffffffffffffff);
    let mut x8: u64 = 0;
    let mut x9: u64 = 0;
    let (x8, x9) = fiat_p384_mulx_u64(x2, 0xffffffffffffffff);
    let mut x10: u64 = 0;
    let mut x11: u64 = 0;
    let (x10, x11) = fiat_p384_mulx_u64(x2, 0xfffffffffffffffe);
    let mut x12: u64 = 0;
    let mut x13: u64 = 0;
    let (x12, x13) = fiat_p384_mulx_u64(x2, 0xffffffff00000000);
    let mut x14: u64 = 0;
    let mut x15: u64 = 0;
    let (x14, x15) = fiat_p384_mulx_u64(x2, 0xffffffff);
    let mut x16: u64 = 0;
    let mut x17: fiat_p384_u1 = 0;
    let (x16, x17) = fiat_p384_addcarryx_u64(0x0, x15, x12);
    let mut x18: u64 = 0;
    let mut x19: fiat_p384_u1 = 0;
    let (x18, x19) = fiat_p384_addcarryx_u64(x17, x13, x10);
    let mut x20: u64 = 0;
    let mut x21: fiat_p384_u1 = 0;
    let (x20, x21) = fiat_p384_addcarryx_u64(x19, x11, x8);
    let mut x22: u64 = 0;
    let mut x23: fiat_p384_u1 = 0;
    let (x22, x23) = fiat_p384_addcarryx_u64(x21, x9, x6);
    let mut x24: u64 = 0;
    let mut x25: fiat_p384_u1 = 0;
    let (x24, x25) = fiat_p384_addcarryx_u64(x23, x7, x4);
    let mut x26: u64 = 0;
    let mut x27: fiat_p384_u1 = 0;
    let (x26, x27) = fiat_p384_addcarryx_u64(0x0, x1, x14);
    let mut x28: u64 = 0;
    let mut x29: fiat_p384_u1 = 0;
    let (x28, x29) = fiat_p384_addcarryx_u64(x27, (0x0 as u64), x16);
    let mut x30: u64 = 0;
    let mut x31: fiat_p384_u1 = 0;
    let (x30, x31) = fiat_p384_addcarryx_u64(x29, (0x0 as u64), x18);
    let mut x32: u64 = 0;
    let mut x33: fiat_p384_u1 = 0;
    let (x32, x33) = fiat_p384_addcarryx_u64(x31, (0x0 as u64), x20);
    let mut x34: u64 = 0;
    let mut x35: fiat_p384_u1 = 0;
    let (x34, x35) = fiat_p384_addcarryx_u64(x33, (0x0 as u64), x22);
    let mut x36: u64 = 0;
    let mut x37: fiat_p384_u1 = 0;
    let (x36, x37) = fiat_p384_addcarryx_u64(x35, (0x0 as u64), x24);
    let mut x38: u64 = 0;
    let mut x39: fiat_p384_u1 = 0;
    let (x38, x39) = fiat_p384_addcarryx_u64(x37, (0x0 as u64), ((x25 as u64) + x5));
    let mut x40: u64 = 0;
    let mut x41: fiat_p384_u1 = 0;
    let (x40, x41) = fiat_p384_addcarryx_u64(0x0, x28, (arg1[1]));
    let mut x42: u64 = 0;
    let mut x43: fiat_p384_u1 = 0;
    let (x42, x43) = fiat_p384_addcarryx_u64(x41, x30, (0x0 as u64));
    let mut x44: u64 = 0;
    let mut x45: fiat_p384_u1 = 0;
    let (x44, x45) = fiat_p384_addcarryx_u64(x43, x32, (0x0 as u64));
    let mut x46: u64 = 0;
    let mut x47: fiat_p384_u1 = 0;
    let (x46, x47) = fiat_p384_addcarryx_u64(x45, x34, (0x0 as u64));
    let mut x48: u64 = 0;
    let mut x49: fiat_p384_u1 = 0;
    let (x48, x49) = fiat_p384_addcarryx_u64(x47, x36, (0x0 as u64));
    let mut x50: u64 = 0;
    let mut x51: fiat_p384_u1 = 0;
    let (x50, x51) = fiat_p384_addcarryx_u64(x49, x38, (0x0 as u64));
    let mut x52: u64 = 0;
    let mut x53: u64 = 0;
    let (x52, x53) = fiat_p384_mulx_u64(x40, 0x100000001);
    let mut x54: u64 = 0;
    let mut x55: u64 = 0;
    let (x54, x55) = fiat_p384_mulx_u64(x52, 0xffffffffffffffff);
    let mut x56: u64 = 0;
    let mut x57: u64 = 0;
    let (x56, x57) = fiat_p384_mulx_u64(x52, 0xffffffffffffffff);
    let mut x58: u64 = 0;
    let mut x59: u64 = 0;
    let (x58, x59) = fiat_p384_mulx_u64(x52, 0xffffffffffffffff);
    let mut x60: u64 = 0;
    let mut x61: u64 = 0;
    let (x60, x61) = fiat_p384_mulx_u64(x52, 0xfffffffffffffffe);
    let mut x62: u64 = 0;
    let mut x63: u64 = 0;
    let (x62, x63) = fiat_p384_mulx_u64(x52, 0xffffffff00000000);
    let mut x64: u64 = 0;
    let mut x65: u64 = 0;
    let (x64, x65) = fiat_p384_mulx_u64(x52, 0xffffffff);
    let mut x66: u64 = 0;
    let mut x67: fiat_p384_u1 = 0;
    let (x66, x67) = fiat_p384_addcarryx_u64(0x0, x65, x62);
    let mut x68: u64 = 0;
    let mut x69: fiat_p384_u1 = 0;
    let (x68, x69) = fiat_p384_addcarryx_u64(x67, x63, x60);
    let mut x70: u64 = 0;
    let mut x71: fiat_p384_u1 = 0;
    let (x70, x71) = fiat_p384_addcarryx_u64(x69, x61, x58);
    let mut x72: u64 = 0;
    let mut x73: fiat_p384_u1 = 0;
    let (x72, x73) = fiat_p384_addcarryx_u64(x71, x59, x56);
    let mut x74: u64 = 0;
    let mut x75: fiat_p384_u1 = 0;
    let (x74, x75) = fiat_p384_addcarryx_u64(x73, x57, x54);
    let mut x76: u64 = 0;
    let mut x77: fiat_p384_u1 = 0;
    let (x76, x77) = fiat_p384_addcarryx_u64(0x0, x40, x64);
    let mut x78: u64 = 0;
    let mut x79: fiat_p384_u1 = 0;
    let (x78, x79) = fiat_p384_addcarryx_u64(x77, x42, x66);
    let mut x80: u64 = 0;
    let mut x81: fiat_p384_u1 = 0;
    let (x80, x81) = fiat_p384_addcarryx_u64(x79, x44, x68);
    let mut x82: u64 = 0;
    let mut x83: fiat_p384_u1 = 0;
    let (x82, x83) = fiat_p384_addcarryx_u64(x81, x46, x70);
    let mut x84: u64 = 0;
    let mut x85: fiat_p384_u1 = 0;
    let (x84, x85) = fiat_p384_addcarryx_u64(x83, x48, x72);
    let mut x86: u64 = 0;
    let mut x87: fiat_p384_u1 = 0;
    let (x86, x87) = fiat_p384_addcarryx_u64(x85, x50, x74);
    let mut x88: u64 = 0;
    let mut x89: fiat_p384_u1 = 0;
    let (x88, x89) =
        fiat_p384_addcarryx_u64(x87, ((x51 as u64) + (x39 as u64)), ((x75 as u64) + x55));
    let mut x90: u64 = 0;
    let mut x91: fiat_p384_u1 = 0;
    let (x90, x91) = fiat_p384_addcarryx_u64(0x0, x78, (arg1[2]));
    let mut x92: u64 = 0;
    let mut x93: fiat_p384_u1 = 0;
    let (x92, x93) = fiat_p384_addcarryx_u64(x91, x80, (0x0 as u64));
    let mut x94: u64 = 0;
    let mut x95: fiat_p384_u1 = 0;
    let (x94, x95) = fiat_p384_addcarryx_u64(x93, x82, (0x0 as u64));
    let mut x96: u64 = 0;
    let mut x97: fiat_p384_u1 = 0;
    let (x96, x97) = fiat_p384_addcarryx_u64(x95, x84, (0x0 as u64));
    let mut x98: u64 = 0;
    let mut x99: fiat_p384_u1 = 0;
    let (x98, x99) = fiat_p384_addcarryx_u64(x97, x86, (0x0 as u64));
    let mut x100: u64 = 0;
    let mut x101: fiat_p384_u1 = 0;
    let (x100, x101) = fiat_p384_addcarryx_u64(x99, x88, (0x0 as u64));
    let mut x102: u64 = 0;
    let mut x103: u64 = 0;
    let (x102, x103) = fiat_p384_mulx_u64(x90, 0x100000001);
    let mut x104: u64 = 0;
    let mut x105: u64 = 0;
    let (x104, x105) = fiat_p384_mulx_u64(x102, 0xffffffffffffffff);
    let mut x106: u64 = 0;
    let mut x107: u64 = 0;
    let (x106, x107) = fiat_p384_mulx_u64(x102, 0xffffffffffffffff);
    let mut x108: u64 = 0;
    let mut x109: u64 = 0;
    let (x108, x109) = fiat_p384_mulx_u64(x102, 0xffffffffffffffff);
    let mut x110: u64 = 0;
    let mut x111: u64 = 0;
    let (x110, x111) = fiat_p384_mulx_u64(x102, 0xfffffffffffffffe);
    let mut x112: u64 = 0;
    let mut x113: u64 = 0;
    let (x112, x113) = fiat_p384_mulx_u64(x102, 0xffffffff00000000);
    let mut x114: u64 = 0;
    let mut x115: u64 = 0;
    let (x114, x115) = fiat_p384_mulx_u64(x102, 0xffffffff);
    let mut x116: u64 = 0;
    let mut x117: fiat_p384_u1 = 0;
    let (x116, x117) = fiat_p384_addcarryx_u64(0x0, x115, x112);
    let mut x118: u64 = 0;
    let mut x119: fiat_p384_u1 = 0;
    let (x118, x119) = fiat_p384_addcarryx_u64(x117, x113, x110);
    let mut x120: u64 = 0;
    let mut x121: fiat_p384_u1 = 0;
    let (x120, x121) = fiat_p384_addcarryx_u64(x119, x111, x108);
    let mut x122: u64 = 0;
    let mut x123: fiat_p384_u1 = 0;
    let (x122, x123) = fiat_p384_addcarryx_u64(x121, x109, x106);
    let mut x124: u64 = 0;
    let mut x125: fiat_p384_u1 = 0;
    let (x124, x125) = fiat_p384_addcarryx_u64(x123, x107, x104);
    let mut x126: u64 = 0;
    let mut x127: fiat_p384_u1 = 0;
    let (x126, x127) = fiat_p384_addcarryx_u64(0x0, x90, x114);
    let mut x128: u64 = 0;
    let mut x129: fiat_p384_u1 = 0;
    let (x128, x129) = fiat_p384_addcarryx_u64(x127, x92, x116);
    let mut x130: u64 = 0;
    let mut x131: fiat_p384_u1 = 0;
    let (x130, x131) = fiat_p384_addcarryx_u64(x129, x94, x118);
    let mut x132: u64 = 0;
    let mut x133: fiat_p384_u1 = 0;
    let (x132, x133) = fiat_p384_addcarryx_u64(x131, x96, x120);
    let mut x134: u64 = 0;
    let mut x135: fiat_p384_u1 = 0;
    let (x134, x135) = fiat_p384_addcarryx_u64(x133, x98, x122);
    let mut x136: u64 = 0;
    let mut x137: fiat_p384_u1 = 0;
    let (x136, x137) = fiat_p384_addcarryx_u64(x135, x100, x124);
    let mut x138: u64 = 0;
    let mut x139: fiat_p384_u1 = 0;
    let (x138, x139) =
        fiat_p384_addcarryx_u64(x137, ((x101 as u64) + (x89 as u64)), ((x125 as u64) + x105));
    let mut x140: u64 = 0;
    let mut x141: fiat_p384_u1 = 0;
    let (x140, x141) = fiat_p384_addcarryx_u64(0x0, x128, (arg1[3]));
    let mut x142: u64 = 0;
    let mut x143: fiat_p384_u1 = 0;
    let (x142, x143) = fiat_p384_addcarryx_u64(x141, x130, (0x0 as u64));
    let mut x144: u64 = 0;
    let mut x145: fiat_p384_u1 = 0;
    let (x144, x145) = fiat_p384_addcarryx_u64(x143, x132, (0x0 as u64));
    let mut x146: u64 = 0;
    let mut x147: fiat_p384_u1 = 0;
    let (x146, x147) = fiat_p384_addcarryx_u64(x145, x134, (0x0 as u64));
    let mut x148: u64 = 0;
    let mut x149: fiat_p384_u1 = 0;
    let (x148, x149) = fiat_p384_addcarryx_u64(x147, x136, (0x0 as u64));
    let mut x150: u64 = 0;
    let mut x151: fiat_p384_u1 = 0;
    let (x150, x151) = fiat_p384_addcarryx_u64(x149, x138, (0x0 as u64));
    let mut x152: u64 = 0;
    let mut x153: u64 = 0;
    let (x152, x153) = fiat_p384_mulx_u64(x140, 0x100000001);
    let mut x154: u64 = 0;
    let mut x155: u64 = 0;
    let (x154, x155) = fiat_p384_mulx_u64(x152, 0xffffffffffffffff);
    let mut x156: u64 = 0;
    let mut x157: u64 = 0;
    let (x156, x157) = fiat_p384_mulx_u64(x152, 0xffffffffffffffff);
    let mut x158: u64 = 0;
    let mut x159: u64 = 0;
    let (x158, x159) = fiat_p384_mulx_u64(x152, 0xffffffffffffffff);
    let mut x160: u64 = 0;
    let mut x161: u64 = 0;
    let (x160, x161) = fiat_p384_mulx_u64(x152, 0xfffffffffffffffe);
    let mut x162: u64 = 0;
    let mut x163: u64 = 0;
    let (x162, x163) = fiat_p384_mulx_u64(x152, 0xffffffff00000000);
    let mut x164: u64 = 0;
    let mut x165: u64 = 0;
    let (x164, x165) = fiat_p384_mulx_u64(x152, 0xffffffff);
    let mut x166: u64 = 0;
    let mut x167: fiat_p384_u1 = 0;
    let (x166, x167) = fiat_p384_addcarryx_u64(0x0, x165, x162);
    let mut x168: u64 = 0;
    let mut x169: fiat_p384_u1 = 0;
    let (x168, x169) = fiat_p384_addcarryx_u64(x167, x163, x160);
    let mut x170: u64 = 0;
    let mut x171: fiat_p384_u1 = 0;
    let (x170, x171) = fiat_p384_addcarryx_u64(x169, x161, x158);
    let mut x172: u64 = 0;
    let mut x173: fiat_p384_u1 = 0;
    let (x172, x173) = fiat_p384_addcarryx_u64(x171, x159, x156);
    let mut x174: u64 = 0;
    let mut x175: fiat_p384_u1 = 0;
    let (x174, x175) = fiat_p384_addcarryx_u64(x173, x157, x154);
    let mut x176: u64 = 0;
    let mut x177: fiat_p384_u1 = 0;
    let (x176, x177) = fiat_p384_addcarryx_u64(0x0, x140, x164);
    let mut x178: u64 = 0;
    let mut x179: fiat_p384_u1 = 0;
    let (x178, x179) = fiat_p384_addcarryx_u64(x177, x142, x166);
    let mut x180: u64 = 0;
    let mut x181: fiat_p384_u1 = 0;
    let (x180, x181) = fiat_p384_addcarryx_u64(x179, x144, x168);
    let mut x182: u64 = 0;
    let mut x183: fiat_p384_u1 = 0;
    let (x182, x183) = fiat_p384_addcarryx_u64(x181, x146, x170);
    let mut x184: u64 = 0;
    let mut x185: fiat_p384_u1 = 0;
    let (x184, x185) = fiat_p384_addcarryx_u64(x183, x148, x172);
    let mut x186: u64 = 0;
    let mut x187: fiat_p384_u1 = 0;
    let (x186, x187) = fiat_p384_addcarryx_u64(x185, x150, x174);
    let mut x188: u64 = 0;
    let mut x189: fiat_p384_u1 = 0;
    let (x188, x189) = fiat_p384_addcarryx_u64(
        x187,
        ((x151 as u64) + (x139 as u64)),
        ((x175 as u64) + x155),
    );
    let mut x190: u64 = 0;
    let mut x191: fiat_p384_u1 = 0;
    let (x190, x191) = fiat_p384_addcarryx_u64(0x0, x178, (arg1[4]));
    let mut x192: u64 = 0;
    let mut x193: fiat_p384_u1 = 0;
    let (x192, x193) = fiat_p384_addcarryx_u64(x191, x180, (0x0 as u64));
    let mut x194: u64 = 0;
    let mut x195: fiat_p384_u1 = 0;
    let (x194, x195) = fiat_p384_addcarryx_u64(x193, x182, (0x0 as u64));
    let mut x196: u64 = 0;
    let mut x197: fiat_p384_u1 = 0;
    let (x196, x197) = fiat_p384_addcarryx_u64(x195, x184, (0x0 as u64));
    let mut x198: u64 = 0;
    let mut x199: fiat_p384_u1 = 0;
    let (x198, x199) = fiat_p384_addcarryx_u64(x197, x186, (0x0 as u64));
    let mut x200: u64 = 0;
    let mut x201: fiat_p384_u1 = 0;
    let (x200, x201) = fiat_p384_addcarryx_u64(x199, x188, (0x0 as u64));
    let mut x202: u64 = 0;
    let mut x203: u64 = 0;
    let (x202, x203) = fiat_p384_mulx_u64(x190, 0x100000001);
    let mut x204: u64 = 0;
    let mut x205: u64 = 0;
    let (x204, x205) = fiat_p384_mulx_u64(x202, 0xffffffffffffffff);
    let mut x206: u64 = 0;
    let mut x207: u64 = 0;
    let (x206, x207) = fiat_p384_mulx_u64(x202, 0xffffffffffffffff);
    let mut x208: u64 = 0;
    let mut x209: u64 = 0;
    let (x208, x209) = fiat_p384_mulx_u64(x202, 0xffffffffffffffff);
    let mut x210: u64 = 0;
    let mut x211: u64 = 0;
    let (x210, x211) = fiat_p384_mulx_u64(x202, 0xfffffffffffffffe);
    let mut x212: u64 = 0;
    let mut x213: u64 = 0;
    let (x212, x213) = fiat_p384_mulx_u64(x202, 0xffffffff00000000);
    let mut x214: u64 = 0;
    let mut x215: u64 = 0;
    let (x214, x215) = fiat_p384_mulx_u64(x202, 0xffffffff);
    let mut x216: u64 = 0;
    let mut x217: fiat_p384_u1 = 0;
    let (x216, x217) = fiat_p384_addcarryx_u64(0x0, x215, x212);
    let mut x218: u64 = 0;
    let mut x219: fiat_p384_u1 = 0;
    let (x218, x219) = fiat_p384_addcarryx_u64(x217, x213, x210);
    let mut x220: u64 = 0;
    let mut x221: fiat_p384_u1 = 0;
    let (x220, x221) = fiat_p384_addcarryx_u64(x219, x211, x208);
    let mut x222: u64 = 0;
    let mut x223: fiat_p384_u1 = 0;
    let (x222, x223) = fiat_p384_addcarryx_u64(x221, x209, x206);
    let mut x224: u64 = 0;
    let mut x225: fiat_p384_u1 = 0;
    let (x224, x225) = fiat_p384_addcarryx_u64(x223, x207, x204);
    let mut x226: u64 = 0;
    let mut x227: fiat_p384_u1 = 0;
    let (x226, x227) = fiat_p384_addcarryx_u64(0x0, x190, x214);
    let mut x228: u64 = 0;
    let mut x229: fiat_p384_u1 = 0;
    let (x228, x229) = fiat_p384_addcarryx_u64(x227, x192, x216);
    let mut x230: u64 = 0;
    let mut x231: fiat_p384_u1 = 0;
    let (x230, x231) = fiat_p384_addcarryx_u64(x229, x194, x218);
    let mut x232: u64 = 0;
    let mut x233: fiat_p384_u1 = 0;
    let (x232, x233) = fiat_p384_addcarryx_u64(x231, x196, x220);
    let mut x234: u64 = 0;
    let mut x235: fiat_p384_u1 = 0;
    let (x234, x235) = fiat_p384_addcarryx_u64(x233, x198, x222);
    let mut x236: u64 = 0;
    let mut x237: fiat_p384_u1 = 0;
    let (x236, x237) = fiat_p384_addcarryx_u64(x235, x200, x224);
    let mut x238: u64 = 0;
    let mut x239: fiat_p384_u1 = 0;
    let (x238, x239) = fiat_p384_addcarryx_u64(
        x237,
        ((x201 as u64) + (x189 as u64)),
        ((x225 as u64) + x205),
    );
    let mut x240: u64 = 0;
    let mut x241: fiat_p384_u1 = 0;
    let (x240, x241) = fiat_p384_addcarryx_u64(0x0, x228, (arg1[5]));
    let mut x242: u64 = 0;
    let mut x243: fiat_p384_u1 = 0;
    let (x242, x243) = fiat_p384_addcarryx_u64(x241, x230, (0x0 as u64));
    let mut x244: u64 = 0;
    let mut x245: fiat_p384_u1 = 0;
    let (x244, x245) = fiat_p384_addcarryx_u64(x243, x232, (0x0 as u64));
    let mut x246: u64 = 0;
    let mut x247: fiat_p384_u1 = 0;
    let (x246, x247) = fiat_p384_addcarryx_u64(x245, x234, (0x0 as u64));
    let mut x248: u64 = 0;
    let mut x249: fiat_p384_u1 = 0;
    let (x248, x249) = fiat_p384_addcarryx_u64(x247, x236, (0x0 as u64));
    let mut x250: u64 = 0;
    let mut x251: fiat_p384_u1 = 0;
    let (x250, x251) = fiat_p384_addcarryx_u64(x249, x238, (0x0 as u64));
    let mut x252: u64 = 0;
    let mut x253: u64 = 0;
    let (x252, x253) = fiat_p384_mulx_u64(x240, 0x100000001);
    let mut x254: u64 = 0;
    let mut x255: u64 = 0;
    let (x254, x255) = fiat_p384_mulx_u64(x252, 0xffffffffffffffff);
    let mut x256: u64 = 0;
    let mut x257: u64 = 0;
    let (x256, x257) = fiat_p384_mulx_u64(x252, 0xffffffffffffffff);
    let mut x258: u64 = 0;
    let mut x259: u64 = 0;
    let (x258, x259) = fiat_p384_mulx_u64(x252, 0xffffffffffffffff);
    let mut x260: u64 = 0;
    let mut x261: u64 = 0;
    let (x260, x261) = fiat_p384_mulx_u64(x252, 0xfffffffffffffffe);
    let mut x262: u64 = 0;
    let mut x263: u64 = 0;
    let (x262, x263) = fiat_p384_mulx_u64(x252, 0xffffffff00000000);
    let mut x264: u64 = 0;
    let mut x265: u64 = 0;
    let (x264, x265) = fiat_p384_mulx_u64(x252, 0xffffffff);
    let mut x266: u64 = 0;
    let mut x267: fiat_p384_u1 = 0;
    let (x266, x267) = fiat_p384_addcarryx_u64(0x0, x265, x262);
    let mut x268: u64 = 0;
    let mut x269: fiat_p384_u1 = 0;
    let (x268, x269) = fiat_p384_addcarryx_u64(x267, x263, x260);
    let mut x270: u64 = 0;
    let mut x271: fiat_p384_u1 = 0;
    let (x270, x271) = fiat_p384_addcarryx_u64(x269, x261, x258);
    let mut x272: u64 = 0;
    let mut x273: fiat_p384_u1 = 0;
    let (x272, x273) = fiat_p384_addcarryx_u64(x271, x259, x256);
    let mut x274: u64 = 0;
    let mut x275: fiat_p384_u1 = 0;
    let (x274, x275) = fiat_p384_addcarryx_u64(x273, x257, x254);
    let mut x276: u64 = 0;
    let mut x277: fiat_p384_u1 = 0;
    let (x276, x277) = fiat_p384_addcarryx_u64(0x0, x240, x264);
    let mut x278: u64 = 0;
    let mut x279: fiat_p384_u1 = 0;
    let (x278, x279) = fiat_p384_addcarryx_u64(x277, x242, x266);
    let mut x280: u64 = 0;
    let mut x281: fiat_p384_u1 = 0;
    let (x280, x281) = fiat_p384_addcarryx_u64(x279, x244, x268);
    let mut x282: u64 = 0;
    let mut x283: fiat_p384_u1 = 0;
    let (x282, x283) = fiat_p384_addcarryx_u64(x281, x246, x270);
    let mut x284: u64 = 0;
    let mut x285: fiat_p384_u1 = 0;
    let (x284, x285) = fiat_p384_addcarryx_u64(x283, x248, x272);
    let mut x286: u64 = 0;
    let mut x287: fiat_p384_u1 = 0;
    let (x286, x287) = fiat_p384_addcarryx_u64(x285, x250, x274);
    let mut x288: u64 = 0;
    let mut x289: fiat_p384_u1 = 0;
    let (x288, x289) = fiat_p384_addcarryx_u64(
        x287,
        ((x251 as u64) + (x239 as u64)),
        ((x275 as u64) + x255),
    );
    let mut x290: u64 = 0;
    let mut x291: fiat_p384_u1 = 0;
    let (x290, x291) = fiat_p384_subborrowx_u64(0x0, x278, 0xffffffff);
    let mut x292: u64 = 0;
    let mut x293: fiat_p384_u1 = 0;
    let (x292, x293) = fiat_p384_subborrowx_u64(x291, x280, 0xffffffff00000000);
    let mut x294: u64 = 0;
    let mut x295: fiat_p384_u1 = 0;
    let (x294, x295) = fiat_p384_subborrowx_u64(x293, x282, 0xfffffffffffffffe);
    let mut x296: u64 = 0;
    let mut x297: fiat_p384_u1 = 0;
    let (x296, x297) = fiat_p384_subborrowx_u64(x295, x284, 0xffffffffffffffff);
    let mut x298: u64 = 0;
    let mut x299: fiat_p384_u1 = 0;
    let (x298, x299) = fiat_p384_subborrowx_u64(x297, x286, 0xffffffffffffffff);
    let mut x300: u64 = 0;
    let mut x301: fiat_p384_u1 = 0;
    let (x300, x301) = fiat_p384_subborrowx_u64(x299, x288, 0xffffffffffffffff);
    let mut x302: u64 = 0;
    let mut x303: fiat_p384_u1 = 0;
    let (x302, x303) = fiat_p384_subborrowx_u64(x301, (x289 as u64), (0x0 as u64));
    let mut x304: u64 = 0;
    let (x304) = fiat_p384_cmovznz_u64(x303, x290, x278);
    let mut x305: u64 = 0;
    let (x305) = fiat_p384_cmovznz_u64(x303, x292, x280);
    let mut x306: u64 = 0;
    let (x306) = fiat_p384_cmovznz_u64(x303, x294, x282);
    let mut x307: u64 = 0;
    let (x307) = fiat_p384_cmovznz_u64(x303, x296, x284);
    let mut x308: u64 = 0;
    let (x308) = fiat_p384_cmovznz_u64(x303, x298, x286);
    let mut x309: u64 = 0;
    let (x309) = fiat_p384_cmovznz_u64(x303, x300, x288);
    out1[0] = x304;
    out1[1] = x305;
    out1[2] = x306;
    out1[3] = x307;
    out1[4] = x308;
    out1[5] = x309;
    out1
}
#[doc = " The function fiat_p384_to_montgomery translates a field element into the Montgomery domain."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = eval arg1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_to_montgomery(
    arg1: &fiat_p384_non_montgomery_domain_field_element,
) -> fiat_p384_montgomery_domain_field_element {
    let mut out1: fiat_p384_montgomery_domain_field_element = [0; 6];
    let x1: u64 = (arg1[1]);
    let x2: u64 = (arg1[2]);
    let x3: u64 = (arg1[3]);
    let x4: u64 = (arg1[4]);
    let x5: u64 = (arg1[5]);
    let x6: u64 = (arg1[0]);
    let mut x7: u64 = 0;
    let mut x8: u64 = 0;
    let (x7, x8) = fiat_p384_mulx_u64(x6, 0x200000000);
    let mut x9: u64 = 0;
    let mut x10: u64 = 0;
    let (x9, x10) = fiat_p384_mulx_u64(x6, 0xfffffffe00000000);
    let mut x11: u64 = 0;
    let mut x12: u64 = 0;
    let (x11, x12) = fiat_p384_mulx_u64(x6, 0x200000000);
    let mut x13: u64 = 0;
    let mut x14: u64 = 0;
    let (x13, x14) = fiat_p384_mulx_u64(x6, 0xfffffffe00000001);
    let mut x15: u64 = 0;
    let mut x16: fiat_p384_u1 = 0;
    let (x15, x16) = fiat_p384_addcarryx_u64(0x0, x14, x11);
    let mut x17: u64 = 0;
    let mut x18: fiat_p384_u1 = 0;
    let (x17, x18) = fiat_p384_addcarryx_u64(x16, x12, x9);
    let mut x19: u64 = 0;
    let mut x20: fiat_p384_u1 = 0;
    let (x19, x20) = fiat_p384_addcarryx_u64(x18, x10, x7);
    let mut x21: u64 = 0;
    let mut x22: fiat_p384_u1 = 0;
    let (x21, x22) = fiat_p384_addcarryx_u64(x20, x8, x6);
    let mut x23: u64 = 0;
    let mut x24: u64 = 0;
    let (x23, x24) = fiat_p384_mulx_u64(x13, 0x100000001);
    let mut x25: u64 = 0;
    let mut x26: u64 = 0;
    let (x25, x26) = fiat_p384_mulx_u64(x23, 0xffffffffffffffff);
    let mut x27: u64 = 0;
    let mut x28: u64 = 0;
    let (x27, x28) = fiat_p384_mulx_u64(x23, 0xffffffffffffffff);
    let mut x29: u64 = 0;
    let mut x30: u64 = 0;
    let (x29, x30) = fiat_p384_mulx_u64(x23, 0xffffffffffffffff);
    let mut x31: u64 = 0;
    let mut x32: u64 = 0;
    let (x31, x32) = fiat_p384_mulx_u64(x23, 0xfffffffffffffffe);
    let mut x33: u64 = 0;
    let mut x34: u64 = 0;
    let (x33, x34) = fiat_p384_mulx_u64(x23, 0xffffffff00000000);
    let mut x35: u64 = 0;
    let mut x36: u64 = 0;
    let (x35, x36) = fiat_p384_mulx_u64(x23, 0xffffffff);
    let mut x37: u64 = 0;
    let mut x38: fiat_p384_u1 = 0;
    let (x37, x38) = fiat_p384_addcarryx_u64(0x0, x36, x33);
    let mut x39: u64 = 0;
    let mut x40: fiat_p384_u1 = 0;
    let (x39, x40) = fiat_p384_addcarryx_u64(x38, x34, x31);
    let mut x41: u64 = 0;
    let mut x42: fiat_p384_u1 = 0;
    let (x41, x42) = fiat_p384_addcarryx_u64(x40, x32, x29);
    let mut x43: u64 = 0;
    let mut x44: fiat_p384_u1 = 0;
    let (x43, x44) = fiat_p384_addcarryx_u64(x42, x30, x27);
    let mut x45: u64 = 0;
    let mut x46: fiat_p384_u1 = 0;
    let (x45, x46) = fiat_p384_addcarryx_u64(x44, x28, x25);
    let mut x47: u64 = 0;
    let mut x48: fiat_p384_u1 = 0;
    let (x47, x48) = fiat_p384_addcarryx_u64(0x0, x13, x35);
    let mut x49: u64 = 0;
    let mut x50: fiat_p384_u1 = 0;
    let (x49, x50) = fiat_p384_addcarryx_u64(x48, x15, x37);
    let mut x51: u64 = 0;
    let mut x52: fiat_p384_u1 = 0;
    let (x51, x52) = fiat_p384_addcarryx_u64(x50, x17, x39);
    let mut x53: u64 = 0;
    let mut x54: fiat_p384_u1 = 0;
    let (x53, x54) = fiat_p384_addcarryx_u64(x52, x19, x41);
    let mut x55: u64 = 0;
    let mut x56: fiat_p384_u1 = 0;
    let (x55, x56) = fiat_p384_addcarryx_u64(x54, x21, x43);
    let mut x57: u64 = 0;
    let mut x58: fiat_p384_u1 = 0;
    let (x57, x58) = fiat_p384_addcarryx_u64(x56, (x22 as u64), x45);
    let mut x59: u64 = 0;
    let mut x60: fiat_p384_u1 = 0;
    let (x59, x60) = fiat_p384_addcarryx_u64(x58, (0x0 as u64), ((x46 as u64) + x26));
    let mut x61: u64 = 0;
    let mut x62: u64 = 0;
    let (x61, x62) = fiat_p384_mulx_u64(x1, 0x200000000);
    let mut x63: u64 = 0;
    let mut x64: u64 = 0;
    let (x63, x64) = fiat_p384_mulx_u64(x1, 0xfffffffe00000000);
    let mut x65: u64 = 0;
    let mut x66: u64 = 0;
    let (x65, x66) = fiat_p384_mulx_u64(x1, 0x200000000);
    let mut x67: u64 = 0;
    let mut x68: u64 = 0;
    let (x67, x68) = fiat_p384_mulx_u64(x1, 0xfffffffe00000001);
    let mut x69: u64 = 0;
    let mut x70: fiat_p384_u1 = 0;
    let (x69, x70) = fiat_p384_addcarryx_u64(0x0, x68, x65);
    let mut x71: u64 = 0;
    let mut x72: fiat_p384_u1 = 0;
    let (x71, x72) = fiat_p384_addcarryx_u64(x70, x66, x63);
    let mut x73: u64 = 0;
    let mut x74: fiat_p384_u1 = 0;
    let (x73, x74) = fiat_p384_addcarryx_u64(x72, x64, x61);
    let mut x75: u64 = 0;
    let mut x76: fiat_p384_u1 = 0;
    let (x75, x76) = fiat_p384_addcarryx_u64(x74, x62, x1);
    let mut x77: u64 = 0;
    let mut x78: fiat_p384_u1 = 0;
    let (x77, x78) = fiat_p384_addcarryx_u64(0x0, x49, x67);
    let mut x79: u64 = 0;
    let mut x80: fiat_p384_u1 = 0;
    let (x79, x80) = fiat_p384_addcarryx_u64(x78, x51, x69);
    let mut x81: u64 = 0;
    let mut x82: fiat_p384_u1 = 0;
    let (x81, x82) = fiat_p384_addcarryx_u64(x80, x53, x71);
    let mut x83: u64 = 0;
    let mut x84: fiat_p384_u1 = 0;
    let (x83, x84) = fiat_p384_addcarryx_u64(x82, x55, x73);
    let mut x85: u64 = 0;
    let mut x86: fiat_p384_u1 = 0;
    let (x85, x86) = fiat_p384_addcarryx_u64(x84, x57, x75);
    let mut x87: u64 = 0;
    let mut x88: fiat_p384_u1 = 0;
    let (x87, x88) = fiat_p384_addcarryx_u64(x86, x59, (x76 as u64));
    let mut x89: u64 = 0;
    let mut x90: u64 = 0;
    let (x89, x90) = fiat_p384_mulx_u64(x77, 0x100000001);
    let mut x91: u64 = 0;
    let mut x92: u64 = 0;
    let (x91, x92) = fiat_p384_mulx_u64(x89, 0xffffffffffffffff);
    let mut x93: u64 = 0;
    let mut x94: u64 = 0;
    let (x93, x94) = fiat_p384_mulx_u64(x89, 0xffffffffffffffff);
    let mut x95: u64 = 0;
    let mut x96: u64 = 0;
    let (x95, x96) = fiat_p384_mulx_u64(x89, 0xffffffffffffffff);
    let mut x97: u64 = 0;
    let mut x98: u64 = 0;
    let (x97, x98) = fiat_p384_mulx_u64(x89, 0xfffffffffffffffe);
    let mut x99: u64 = 0;
    let mut x100: u64 = 0;
    let (x99, x100) = fiat_p384_mulx_u64(x89, 0xffffffff00000000);
    let mut x101: u64 = 0;
    let mut x102: u64 = 0;
    let (x101, x102) = fiat_p384_mulx_u64(x89, 0xffffffff);
    let mut x103: u64 = 0;
    let mut x104: fiat_p384_u1 = 0;
    let (x103, x104) = fiat_p384_addcarryx_u64(0x0, x102, x99);
    let mut x105: u64 = 0;
    let mut x106: fiat_p384_u1 = 0;
    let (x105, x106) = fiat_p384_addcarryx_u64(x104, x100, x97);
    let mut x107: u64 = 0;
    let mut x108: fiat_p384_u1 = 0;
    let (x107, x108) = fiat_p384_addcarryx_u64(x106, x98, x95);
    let mut x109: u64 = 0;
    let mut x110: fiat_p384_u1 = 0;
    let (x109, x110) = fiat_p384_addcarryx_u64(x108, x96, x93);
    let mut x111: u64 = 0;
    let mut x112: fiat_p384_u1 = 0;
    let (x111, x112) = fiat_p384_addcarryx_u64(x110, x94, x91);
    let mut x113: u64 = 0;
    let mut x114: fiat_p384_u1 = 0;
    let (x113, x114) = fiat_p384_addcarryx_u64(0x0, x77, x101);
    let mut x115: u64 = 0;
    let mut x116: fiat_p384_u1 = 0;
    let (x115, x116) = fiat_p384_addcarryx_u64(x114, x79, x103);
    let mut x117: u64 = 0;
    let mut x118: fiat_p384_u1 = 0;
    let (x117, x118) = fiat_p384_addcarryx_u64(x116, x81, x105);
    let mut x119: u64 = 0;
    let mut x120: fiat_p384_u1 = 0;
    let (x119, x120) = fiat_p384_addcarryx_u64(x118, x83, x107);
    let mut x121: u64 = 0;
    let mut x122: fiat_p384_u1 = 0;
    let (x121, x122) = fiat_p384_addcarryx_u64(x120, x85, x109);
    let mut x123: u64 = 0;
    let mut x124: fiat_p384_u1 = 0;
    let (x123, x124) = fiat_p384_addcarryx_u64(x122, x87, x111);
    let mut x125: u64 = 0;
    let mut x126: fiat_p384_u1 = 0;
    let (x125, x126) =
        fiat_p384_addcarryx_u64(x124, ((x88 as u64) + (x60 as u64)), ((x112 as u64) + x92));
    let mut x127: u64 = 0;
    let mut x128: u64 = 0;
    let (x127, x128) = fiat_p384_mulx_u64(x2, 0x200000000);
    let mut x129: u64 = 0;
    let mut x130: u64 = 0;
    let (x129, x130) = fiat_p384_mulx_u64(x2, 0xfffffffe00000000);
    let mut x131: u64 = 0;
    let mut x132: u64 = 0;
    let (x131, x132) = fiat_p384_mulx_u64(x2, 0x200000000);
    let mut x133: u64 = 0;
    let mut x134: u64 = 0;
    let (x133, x134) = fiat_p384_mulx_u64(x2, 0xfffffffe00000001);
    let mut x135: u64 = 0;
    let mut x136: fiat_p384_u1 = 0;
    let (x135, x136) = fiat_p384_addcarryx_u64(0x0, x134, x131);
    let mut x137: u64 = 0;
    let mut x138: fiat_p384_u1 = 0;
    let (x137, x138) = fiat_p384_addcarryx_u64(x136, x132, x129);
    let mut x139: u64 = 0;
    let mut x140: fiat_p384_u1 = 0;
    let (x139, x140) = fiat_p384_addcarryx_u64(x138, x130, x127);
    let mut x141: u64 = 0;
    let mut x142: fiat_p384_u1 = 0;
    let (x141, x142) = fiat_p384_addcarryx_u64(x140, x128, x2);
    let mut x143: u64 = 0;
    let mut x144: fiat_p384_u1 = 0;
    let (x143, x144) = fiat_p384_addcarryx_u64(0x0, x115, x133);
    let mut x145: u64 = 0;
    let mut x146: fiat_p384_u1 = 0;
    let (x145, x146) = fiat_p384_addcarryx_u64(x144, x117, x135);
    let mut x147: u64 = 0;
    let mut x148: fiat_p384_u1 = 0;
    let (x147, x148) = fiat_p384_addcarryx_u64(x146, x119, x137);
    let mut x149: u64 = 0;
    let mut x150: fiat_p384_u1 = 0;
    let (x149, x150) = fiat_p384_addcarryx_u64(x148, x121, x139);
    let mut x151: u64 = 0;
    let mut x152: fiat_p384_u1 = 0;
    let (x151, x152) = fiat_p384_addcarryx_u64(x150, x123, x141);
    let mut x153: u64 = 0;
    let mut x154: fiat_p384_u1 = 0;
    let (x153, x154) = fiat_p384_addcarryx_u64(x152, x125, (x142 as u64));
    let mut x155: u64 = 0;
    let mut x156: u64 = 0;
    let (x155, x156) = fiat_p384_mulx_u64(x143, 0x100000001);
    let mut x157: u64 = 0;
    let mut x158: u64 = 0;
    let (x157, x158) = fiat_p384_mulx_u64(x155, 0xffffffffffffffff);
    let mut x159: u64 = 0;
    let mut x160: u64 = 0;
    let (x159, x160) = fiat_p384_mulx_u64(x155, 0xffffffffffffffff);
    let mut x161: u64 = 0;
    let mut x162: u64 = 0;
    let (x161, x162) = fiat_p384_mulx_u64(x155, 0xffffffffffffffff);
    let mut x163: u64 = 0;
    let mut x164: u64 = 0;
    let (x163, x164) = fiat_p384_mulx_u64(x155, 0xfffffffffffffffe);
    let mut x165: u64 = 0;
    let mut x166: u64 = 0;
    let (x165, x166) = fiat_p384_mulx_u64(x155, 0xffffffff00000000);
    let mut x167: u64 = 0;
    let mut x168: u64 = 0;
    let (x167, x168) = fiat_p384_mulx_u64(x155, 0xffffffff);
    let mut x169: u64 = 0;
    let mut x170: fiat_p384_u1 = 0;
    let (x169, x170) = fiat_p384_addcarryx_u64(0x0, x168, x165);
    let mut x171: u64 = 0;
    let mut x172: fiat_p384_u1 = 0;
    let (x171, x172) = fiat_p384_addcarryx_u64(x170, x166, x163);
    let mut x173: u64 = 0;
    let mut x174: fiat_p384_u1 = 0;
    let (x173, x174) = fiat_p384_addcarryx_u64(x172, x164, x161);
    let mut x175: u64 = 0;
    let mut x176: fiat_p384_u1 = 0;
    let (x175, x176) = fiat_p384_addcarryx_u64(x174, x162, x159);
    let mut x177: u64 = 0;
    let mut x178: fiat_p384_u1 = 0;
    let (x177, x178) = fiat_p384_addcarryx_u64(x176, x160, x157);
    let mut x179: u64 = 0;
    let mut x180: fiat_p384_u1 = 0;
    let (x179, x180) = fiat_p384_addcarryx_u64(0x0, x143, x167);
    let mut x181: u64 = 0;
    let mut x182: fiat_p384_u1 = 0;
    let (x181, x182) = fiat_p384_addcarryx_u64(x180, x145, x169);
    let mut x183: u64 = 0;
    let mut x184: fiat_p384_u1 = 0;
    let (x183, x184) = fiat_p384_addcarryx_u64(x182, x147, x171);
    let mut x185: u64 = 0;
    let mut x186: fiat_p384_u1 = 0;
    let (x185, x186) = fiat_p384_addcarryx_u64(x184, x149, x173);
    let mut x187: u64 = 0;
    let mut x188: fiat_p384_u1 = 0;
    let (x187, x188) = fiat_p384_addcarryx_u64(x186, x151, x175);
    let mut x189: u64 = 0;
    let mut x190: fiat_p384_u1 = 0;
    let (x189, x190) = fiat_p384_addcarryx_u64(x188, x153, x177);
    let mut x191: u64 = 0;
    let mut x192: fiat_p384_u1 = 0;
    let (x191, x192) = fiat_p384_addcarryx_u64(
        x190,
        ((x154 as u64) + (x126 as u64)),
        ((x178 as u64) + x158),
    );
    let mut x193: u64 = 0;
    let mut x194: u64 = 0;
    let (x193, x194) = fiat_p384_mulx_u64(x3, 0x200000000);
    let mut x195: u64 = 0;
    let mut x196: u64 = 0;
    let (x195, x196) = fiat_p384_mulx_u64(x3, 0xfffffffe00000000);
    let mut x197: u64 = 0;
    let mut x198: u64 = 0;
    let (x197, x198) = fiat_p384_mulx_u64(x3, 0x200000000);
    let mut x199: u64 = 0;
    let mut x200: u64 = 0;
    let (x199, x200) = fiat_p384_mulx_u64(x3, 0xfffffffe00000001);
    let mut x201: u64 = 0;
    let mut x202: fiat_p384_u1 = 0;
    let (x201, x202) = fiat_p384_addcarryx_u64(0x0, x200, x197);
    let mut x203: u64 = 0;
    let mut x204: fiat_p384_u1 = 0;
    let (x203, x204) = fiat_p384_addcarryx_u64(x202, x198, x195);
    let mut x205: u64 = 0;
    let mut x206: fiat_p384_u1 = 0;
    let (x205, x206) = fiat_p384_addcarryx_u64(x204, x196, x193);
    let mut x207: u64 = 0;
    let mut x208: fiat_p384_u1 = 0;
    let (x207, x208) = fiat_p384_addcarryx_u64(x206, x194, x3);
    let mut x209: u64 = 0;
    let mut x210: fiat_p384_u1 = 0;
    let (x209, x210) = fiat_p384_addcarryx_u64(0x0, x181, x199);
    let mut x211: u64 = 0;
    let mut x212: fiat_p384_u1 = 0;
    let (x211, x212) = fiat_p384_addcarryx_u64(x210, x183, x201);
    let mut x213: u64 = 0;
    let mut x214: fiat_p384_u1 = 0;
    let (x213, x214) = fiat_p384_addcarryx_u64(x212, x185, x203);
    let mut x215: u64 = 0;
    let mut x216: fiat_p384_u1 = 0;
    let (x215, x216) = fiat_p384_addcarryx_u64(x214, x187, x205);
    let mut x217: u64 = 0;
    let mut x218: fiat_p384_u1 = 0;
    let (x217, x218) = fiat_p384_addcarryx_u64(x216, x189, x207);
    let mut x219: u64 = 0;
    let mut x220: fiat_p384_u1 = 0;
    let (x219, x220) = fiat_p384_addcarryx_u64(x218, x191, (x208 as u64));
    let mut x221: u64 = 0;
    let mut x222: u64 = 0;
    let (x221, x222) = fiat_p384_mulx_u64(x209, 0x100000001);
    let mut x223: u64 = 0;
    let mut x224: u64 = 0;
    let (x223, x224) = fiat_p384_mulx_u64(x221, 0xffffffffffffffff);
    let mut x225: u64 = 0;
    let mut x226: u64 = 0;
    let (x225, x226) = fiat_p384_mulx_u64(x221, 0xffffffffffffffff);
    let mut x227: u64 = 0;
    let mut x228: u64 = 0;
    let (x227, x228) = fiat_p384_mulx_u64(x221, 0xffffffffffffffff);
    let mut x229: u64 = 0;
    let mut x230: u64 = 0;
    let (x229, x230) = fiat_p384_mulx_u64(x221, 0xfffffffffffffffe);
    let mut x231: u64 = 0;
    let mut x232: u64 = 0;
    let (x231, x232) = fiat_p384_mulx_u64(x221, 0xffffffff00000000);
    let mut x233: u64 = 0;
    let mut x234: u64 = 0;
    let (x233, x234) = fiat_p384_mulx_u64(x221, 0xffffffff);
    let mut x235: u64 = 0;
    let mut x236: fiat_p384_u1 = 0;
    let (x235, x236) = fiat_p384_addcarryx_u64(0x0, x234, x231);
    let mut x237: u64 = 0;
    let mut x238: fiat_p384_u1 = 0;
    let (x237, x238) = fiat_p384_addcarryx_u64(x236, x232, x229);
    let mut x239: u64 = 0;
    let mut x240: fiat_p384_u1 = 0;
    let (x239, x240) = fiat_p384_addcarryx_u64(x238, x230, x227);
    let mut x241: u64 = 0;
    let mut x242: fiat_p384_u1 = 0;
    let (x241, x242) = fiat_p384_addcarryx_u64(x240, x228, x225);
    let mut x243: u64 = 0;
    let mut x244: fiat_p384_u1 = 0;
    let (x243, x244) = fiat_p384_addcarryx_u64(x242, x226, x223);
    let mut x245: u64 = 0;
    let mut x246: fiat_p384_u1 = 0;
    let (x245, x246) = fiat_p384_addcarryx_u64(0x0, x209, x233);
    let mut x247: u64 = 0;
    let mut x248: fiat_p384_u1 = 0;
    let (x247, x248) = fiat_p384_addcarryx_u64(x246, x211, x235);
    let mut x249: u64 = 0;
    let mut x250: fiat_p384_u1 = 0;
    let (x249, x250) = fiat_p384_addcarryx_u64(x248, x213, x237);
    let mut x251: u64 = 0;
    let mut x252: fiat_p384_u1 = 0;
    let (x251, x252) = fiat_p384_addcarryx_u64(x250, x215, x239);
    let mut x253: u64 = 0;
    let mut x254: fiat_p384_u1 = 0;
    let (x253, x254) = fiat_p384_addcarryx_u64(x252, x217, x241);
    let mut x255: u64 = 0;
    let mut x256: fiat_p384_u1 = 0;
    let (x255, x256) = fiat_p384_addcarryx_u64(x254, x219, x243);
    let mut x257: u64 = 0;
    let mut x258: fiat_p384_u1 = 0;
    let (x257, x258) = fiat_p384_addcarryx_u64(
        x256,
        ((x220 as u64) + (x192 as u64)),
        ((x244 as u64) + x224),
    );
    let mut x259: u64 = 0;
    let mut x260: u64 = 0;
    let (x259, x260) = fiat_p384_mulx_u64(x4, 0x200000000);
    let mut x261: u64 = 0;
    let mut x262: u64 = 0;
    let (x261, x262) = fiat_p384_mulx_u64(x4, 0xfffffffe00000000);
    let mut x263: u64 = 0;
    let mut x264: u64 = 0;
    let (x263, x264) = fiat_p384_mulx_u64(x4, 0x200000000);
    let mut x265: u64 = 0;
    let mut x266: u64 = 0;
    let (x265, x266) = fiat_p384_mulx_u64(x4, 0xfffffffe00000001);
    let mut x267: u64 = 0;
    let mut x268: fiat_p384_u1 = 0;
    let (x267, x268) = fiat_p384_addcarryx_u64(0x0, x266, x263);
    let mut x269: u64 = 0;
    let mut x270: fiat_p384_u1 = 0;
    let (x269, x270) = fiat_p384_addcarryx_u64(x268, x264, x261);
    let mut x271: u64 = 0;
    let mut x272: fiat_p384_u1 = 0;
    let (x271, x272) = fiat_p384_addcarryx_u64(x270, x262, x259);
    let mut x273: u64 = 0;
    let mut x274: fiat_p384_u1 = 0;
    let (x273, x274) = fiat_p384_addcarryx_u64(x272, x260, x4);
    let mut x275: u64 = 0;
    let mut x276: fiat_p384_u1 = 0;
    let (x275, x276) = fiat_p384_addcarryx_u64(0x0, x247, x265);
    let mut x277: u64 = 0;
    let mut x278: fiat_p384_u1 = 0;
    let (x277, x278) = fiat_p384_addcarryx_u64(x276, x249, x267);
    let mut x279: u64 = 0;
    let mut x280: fiat_p384_u1 = 0;
    let (x279, x280) = fiat_p384_addcarryx_u64(x278, x251, x269);
    let mut x281: u64 = 0;
    let mut x282: fiat_p384_u1 = 0;
    let (x281, x282) = fiat_p384_addcarryx_u64(x280, x253, x271);
    let mut x283: u64 = 0;
    let mut x284: fiat_p384_u1 = 0;
    let (x283, x284) = fiat_p384_addcarryx_u64(x282, x255, x273);
    let mut x285: u64 = 0;
    let mut x286: fiat_p384_u1 = 0;
    let (x285, x286) = fiat_p384_addcarryx_u64(x284, x257, (x274 as u64));
    let mut x287: u64 = 0;
    let mut x288: u64 = 0;
    let (x287, x288) = fiat_p384_mulx_u64(x275, 0x100000001);
    let mut x289: u64 = 0;
    let mut x290: u64 = 0;
    let (x289, x290) = fiat_p384_mulx_u64(x287, 0xffffffffffffffff);
    let mut x291: u64 = 0;
    let mut x292: u64 = 0;
    let (x291, x292) = fiat_p384_mulx_u64(x287, 0xffffffffffffffff);
    let mut x293: u64 = 0;
    let mut x294: u64 = 0;
    let (x293, x294) = fiat_p384_mulx_u64(x287, 0xffffffffffffffff);
    let mut x295: u64 = 0;
    let mut x296: u64 = 0;
    let (x295, x296) = fiat_p384_mulx_u64(x287, 0xfffffffffffffffe);
    let mut x297: u64 = 0;
    let mut x298: u64 = 0;
    let (x297, x298) = fiat_p384_mulx_u64(x287, 0xffffffff00000000);
    let mut x299: u64 = 0;
    let mut x300: u64 = 0;
    let (x299, x300) = fiat_p384_mulx_u64(x287, 0xffffffff);
    let mut x301: u64 = 0;
    let mut x302: fiat_p384_u1 = 0;
    let (x301, x302) = fiat_p384_addcarryx_u64(0x0, x300, x297);
    let mut x303: u64 = 0;
    let mut x304: fiat_p384_u1 = 0;
    let (x303, x304) = fiat_p384_addcarryx_u64(x302, x298, x295);
    let mut x305: u64 = 0;
    let mut x306: fiat_p384_u1 = 0;
    let (x305, x306) = fiat_p384_addcarryx_u64(x304, x296, x293);
    let mut x307: u64 = 0;
    let mut x308: fiat_p384_u1 = 0;
    let (x307, x308) = fiat_p384_addcarryx_u64(x306, x294, x291);
    let mut x309: u64 = 0;
    let mut x310: fiat_p384_u1 = 0;
    let (x309, x310) = fiat_p384_addcarryx_u64(x308, x292, x289);
    let mut x311: u64 = 0;
    let mut x312: fiat_p384_u1 = 0;
    let (x311, x312) = fiat_p384_addcarryx_u64(0x0, x275, x299);
    let mut x313: u64 = 0;
    let mut x314: fiat_p384_u1 = 0;
    let (x313, x314) = fiat_p384_addcarryx_u64(x312, x277, x301);
    let mut x315: u64 = 0;
    let mut x316: fiat_p384_u1 = 0;
    let (x315, x316) = fiat_p384_addcarryx_u64(x314, x279, x303);
    let mut x317: u64 = 0;
    let mut x318: fiat_p384_u1 = 0;
    let (x317, x318) = fiat_p384_addcarryx_u64(x316, x281, x305);
    let mut x319: u64 = 0;
    let mut x320: fiat_p384_u1 = 0;
    let (x319, x320) = fiat_p384_addcarryx_u64(x318, x283, x307);
    let mut x321: u64 = 0;
    let mut x322: fiat_p384_u1 = 0;
    let (x321, x322) = fiat_p384_addcarryx_u64(x320, x285, x309);
    let mut x323: u64 = 0;
    let mut x324: fiat_p384_u1 = 0;
    let (x323, x324) = fiat_p384_addcarryx_u64(
        x322,
        ((x286 as u64) + (x258 as u64)),
        ((x310 as u64) + x290),
    );
    let mut x325: u64 = 0;
    let mut x326: u64 = 0;
    let (x325, x326) = fiat_p384_mulx_u64(x5, 0x200000000);
    let mut x327: u64 = 0;
    let mut x328: u64 = 0;
    let (x327, x328) = fiat_p384_mulx_u64(x5, 0xfffffffe00000000);
    let mut x329: u64 = 0;
    let mut x330: u64 = 0;
    let (x329, x330) = fiat_p384_mulx_u64(x5, 0x200000000);
    let mut x331: u64 = 0;
    let mut x332: u64 = 0;
    let (x331, x332) = fiat_p384_mulx_u64(x5, 0xfffffffe00000001);
    let mut x333: u64 = 0;
    let mut x334: fiat_p384_u1 = 0;
    let (x333, x334) = fiat_p384_addcarryx_u64(0x0, x332, x329);
    let mut x335: u64 = 0;
    let mut x336: fiat_p384_u1 = 0;
    let (x335, x336) = fiat_p384_addcarryx_u64(x334, x330, x327);
    let mut x337: u64 = 0;
    let mut x338: fiat_p384_u1 = 0;
    let (x337, x338) = fiat_p384_addcarryx_u64(x336, x328, x325);
    let mut x339: u64 = 0;
    let mut x340: fiat_p384_u1 = 0;
    let (x339, x340) = fiat_p384_addcarryx_u64(x338, x326, x5);
    let mut x341: u64 = 0;
    let mut x342: fiat_p384_u1 = 0;
    let (x341, x342) = fiat_p384_addcarryx_u64(0x0, x313, x331);
    let mut x343: u64 = 0;
    let mut x344: fiat_p384_u1 = 0;
    let (x343, x344) = fiat_p384_addcarryx_u64(x342, x315, x333);
    let mut x345: u64 = 0;
    let mut x346: fiat_p384_u1 = 0;
    let (x345, x346) = fiat_p384_addcarryx_u64(x344, x317, x335);
    let mut x347: u64 = 0;
    let mut x348: fiat_p384_u1 = 0;
    let (x347, x348) = fiat_p384_addcarryx_u64(x346, x319, x337);
    let mut x349: u64 = 0;
    let mut x350: fiat_p384_u1 = 0;
    let (x349, x350) = fiat_p384_addcarryx_u64(x348, x321, x339);
    let mut x351: u64 = 0;
    let mut x352: fiat_p384_u1 = 0;
    let (x351, x352) = fiat_p384_addcarryx_u64(x350, x323, (x340 as u64));
    let mut x353: u64 = 0;
    let mut x354: u64 = 0;
    let (x353, x354) = fiat_p384_mulx_u64(x341, 0x100000001);
    let mut x355: u64 = 0;
    let mut x356: u64 = 0;
    let (x355, x356) = fiat_p384_mulx_u64(x353, 0xffffffffffffffff);
    let mut x357: u64 = 0;
    let mut x358: u64 = 0;
    let (x357, x358) = fiat_p384_mulx_u64(x353, 0xffffffffffffffff);
    let mut x359: u64 = 0;
    let mut x360: u64 = 0;
    let (x359, x360) = fiat_p384_mulx_u64(x353, 0xffffffffffffffff);
    let mut x361: u64 = 0;
    let mut x362: u64 = 0;
    let (x361, x362) = fiat_p384_mulx_u64(x353, 0xfffffffffffffffe);
    let mut x363: u64 = 0;
    let mut x364: u64 = 0;
    let (x363, x364) = fiat_p384_mulx_u64(x353, 0xffffffff00000000);
    let mut x365: u64 = 0;
    let mut x366: u64 = 0;
    let (x365, x366) = fiat_p384_mulx_u64(x353, 0xffffffff);
    let mut x367: u64 = 0;
    let mut x368: fiat_p384_u1 = 0;
    let (x367, x368) = fiat_p384_addcarryx_u64(0x0, x366, x363);
    let mut x369: u64 = 0;
    let mut x370: fiat_p384_u1 = 0;
    let (x369, x370) = fiat_p384_addcarryx_u64(x368, x364, x361);
    let mut x371: u64 = 0;
    let mut x372: fiat_p384_u1 = 0;
    let (x371, x372) = fiat_p384_addcarryx_u64(x370, x362, x359);
    let mut x373: u64 = 0;
    let mut x374: fiat_p384_u1 = 0;
    let (x373, x374) = fiat_p384_addcarryx_u64(x372, x360, x357);
    let mut x375: u64 = 0;
    let mut x376: fiat_p384_u1 = 0;
    let (x375, x376) = fiat_p384_addcarryx_u64(x374, x358, x355);
    let mut x377: u64 = 0;
    let mut x378: fiat_p384_u1 = 0;
    let (x377, x378) = fiat_p384_addcarryx_u64(0x0, x341, x365);
    let mut x379: u64 = 0;
    let mut x380: fiat_p384_u1 = 0;
    let (x379, x380) = fiat_p384_addcarryx_u64(x378, x343, x367);
    let mut x381: u64 = 0;
    let mut x382: fiat_p384_u1 = 0;
    let (x381, x382) = fiat_p384_addcarryx_u64(x380, x345, x369);
    let mut x383: u64 = 0;
    let mut x384: fiat_p384_u1 = 0;
    let (x383, x384) = fiat_p384_addcarryx_u64(x382, x347, x371);
    let mut x385: u64 = 0;
    let mut x386: fiat_p384_u1 = 0;
    let (x385, x386) = fiat_p384_addcarryx_u64(x384, x349, x373);
    let mut x387: u64 = 0;
    let mut x388: fiat_p384_u1 = 0;
    let (x387, x388) = fiat_p384_addcarryx_u64(x386, x351, x375);
    let mut x389: u64 = 0;
    let mut x390: fiat_p384_u1 = 0;
    let (x389, x390) = fiat_p384_addcarryx_u64(
        x388,
        ((x352 as u64) + (x324 as u64)),
        ((x376 as u64) + x356),
    );
    let mut x391: u64 = 0;
    let mut x392: fiat_p384_u1 = 0;
    let (x391, x392) = fiat_p384_subborrowx_u64(0x0, x379, 0xffffffff);
    let mut x393: u64 = 0;
    let mut x394: fiat_p384_u1 = 0;
    let (x393, x394) = fiat_p384_subborrowx_u64(x392, x381, 0xffffffff00000000);
    let mut x395: u64 = 0;
    let mut x396: fiat_p384_u1 = 0;
    let (x395, x396) = fiat_p384_subborrowx_u64(x394, x383, 0xfffffffffffffffe);
    let mut x397: u64 = 0;
    let mut x398: fiat_p384_u1 = 0;
    let (x397, x398) = fiat_p384_subborrowx_u64(x396, x385, 0xffffffffffffffff);
    let mut x399: u64 = 0;
    let mut x400: fiat_p384_u1 = 0;
    let (x399, x400) = fiat_p384_subborrowx_u64(x398, x387, 0xffffffffffffffff);
    let mut x401: u64 = 0;
    let mut x402: fiat_p384_u1 = 0;
    let (x401, x402) = fiat_p384_subborrowx_u64(x400, x389, 0xffffffffffffffff);
    let mut x403: u64 = 0;
    let mut x404: fiat_p384_u1 = 0;
    let (x403, x404) = fiat_p384_subborrowx_u64(x402, (x390 as u64), (0x0 as u64));
    let mut x405: u64 = 0;
    let (x405) = fiat_p384_cmovznz_u64(x404, x391, x379);
    let mut x406: u64 = 0;
    let (x406) = fiat_p384_cmovznz_u64(x404, x393, x381);
    let mut x407: u64 = 0;
    let (x407) = fiat_p384_cmovznz_u64(x404, x395, x383);
    let mut x408: u64 = 0;
    let (x408) = fiat_p384_cmovznz_u64(x404, x397, x385);
    let mut x409: u64 = 0;
    let (x409) = fiat_p384_cmovznz_u64(x404, x399, x387);
    let mut x410: u64 = 0;
    let (x410) = fiat_p384_cmovznz_u64(x404, x401, x389);
    out1[0] = x405;
    out1[1] = x406;
    out1[2] = x407;
    out1[3] = x408;
    out1[4] = x409;
    out1[5] = x410;
    out1
}
#[doc = " The function fiat_p384_nonzero outputs a single non-zero word if the input is non-zero and zero otherwise."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = 0 ↔ eval (from_montgomery arg1) mod m = 0"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffffffffffff]"]
#[inline]
pub const fn fiat_p384_nonzero(arg1: &[u64; 6]) -> u64 {
    let mut out1: u64 = 0;
    let x1: u64 = ((arg1[0]) | ((arg1[1]) | ((arg1[2]) | ((arg1[3]) | ((arg1[4]) | (arg1[5]))))));
    out1 = x1;
    out1
}
#[doc = " The function fiat_p384_selectznz is a multi-limb conditional select."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   eval out1 = (if arg1 = 0 then eval arg2 else eval arg3)"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0x1]"]
#[doc = "   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[inline]
pub const fn fiat_p384_selectznz(arg1: fiat_p384_u1, arg2: &[u64; 6], arg3: &[u64; 6]) -> [u64; 6] {
    let mut out1: [u64; 6] = [0; 6];
    let mut x1: u64 = 0;
    let (x1) = fiat_p384_cmovznz_u64(arg1, (arg2[0]), (arg3[0]));
    let mut x2: u64 = 0;
    let (x2) = fiat_p384_cmovznz_u64(arg1, (arg2[1]), (arg3[1]));
    let mut x3: u64 = 0;
    let (x3) = fiat_p384_cmovznz_u64(arg1, (arg2[2]), (arg3[2]));
    let mut x4: u64 = 0;
    let (x4) = fiat_p384_cmovznz_u64(arg1, (arg2[3]), (arg3[3]));
    let mut x5: u64 = 0;
    let (x5) = fiat_p384_cmovznz_u64(arg1, (arg2[4]), (arg3[4]));
    let mut x6: u64 = 0;
    let (x6) = fiat_p384_cmovznz_u64(arg1, (arg2[5]), (arg3[5]));
    out1[0] = x1;
    out1[1] = x2;
    out1[2] = x3;
    out1[3] = x4;
    out1[4] = x5;
    out1[5] = x6;
    out1
}
#[doc = " The function fiat_p384_to_bytes serializes a field element NOT in the Montgomery domain to bytes in little-endian order."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = map (λ x, ⌊((eval arg1 mod m) mod 2^(8 * (x + 1))) / 2^(8 * x)⌋) [0..47]"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]"]
#[inline]
pub const fn fiat_p384_to_bytes(arg1: &[u64; 6]) -> [u8; 48] {
    let mut out1: [u8; 48] = [0; 48];
    let x1: u64 = (arg1[5]);
    let x2: u64 = (arg1[4]);
    let x3: u64 = (arg1[3]);
    let x4: u64 = (arg1[2]);
    let x5: u64 = (arg1[1]);
    let x6: u64 = (arg1[0]);
    let x7: u8 = ((x6 & (0xff as u64)) as u8);
    let x8: u64 = (x6 >> 8);
    let x9: u8 = ((x8 & (0xff as u64)) as u8);
    let x10: u64 = (x8 >> 8);
    let x11: u8 = ((x10 & (0xff as u64)) as u8);
    let x12: u64 = (x10 >> 8);
    let x13: u8 = ((x12 & (0xff as u64)) as u8);
    let x14: u64 = (x12 >> 8);
    let x15: u8 = ((x14 & (0xff as u64)) as u8);
    let x16: u64 = (x14 >> 8);
    let x17: u8 = ((x16 & (0xff as u64)) as u8);
    let x18: u64 = (x16 >> 8);
    let x19: u8 = ((x18 & (0xff as u64)) as u8);
    let x20: u8 = ((x18 >> 8) as u8);
    let x21: u8 = ((x5 & (0xff as u64)) as u8);
    let x22: u64 = (x5 >> 8);
    let x23: u8 = ((x22 & (0xff as u64)) as u8);
    let x24: u64 = (x22 >> 8);
    let x25: u8 = ((x24 & (0xff as u64)) as u8);
    let x26: u64 = (x24 >> 8);
    let x27: u8 = ((x26 & (0xff as u64)) as u8);
    let x28: u64 = (x26 >> 8);
    let x29: u8 = ((x28 & (0xff as u64)) as u8);
    let x30: u64 = (x28 >> 8);
    let x31: u8 = ((x30 & (0xff as u64)) as u8);
    let x32: u64 = (x30 >> 8);
    let x33: u8 = ((x32 & (0xff as u64)) as u8);
    let x34: u8 = ((x32 >> 8) as u8);
    let x35: u8 = ((x4 & (0xff as u64)) as u8);
    let x36: u64 = (x4 >> 8);
    let x37: u8 = ((x36 & (0xff as u64)) as u8);
    let x38: u64 = (x36 >> 8);
    let x39: u8 = ((x38 & (0xff as u64)) as u8);
    let x40: u64 = (x38 >> 8);
    let x41: u8 = ((x40 & (0xff as u64)) as u8);
    let x42: u64 = (x40 >> 8);
    let x43: u8 = ((x42 & (0xff as u64)) as u8);
    let x44: u64 = (x42 >> 8);
    let x45: u8 = ((x44 & (0xff as u64)) as u8);
    let x46: u64 = (x44 >> 8);
    let x47: u8 = ((x46 & (0xff as u64)) as u8);
    let x48: u8 = ((x46 >> 8) as u8);
    let x49: u8 = ((x3 & (0xff as u64)) as u8);
    let x50: u64 = (x3 >> 8);
    let x51: u8 = ((x50 & (0xff as u64)) as u8);
    let x52: u64 = (x50 >> 8);
    let x53: u8 = ((x52 & (0xff as u64)) as u8);
    let x54: u64 = (x52 >> 8);
    let x55: u8 = ((x54 & (0xff as u64)) as u8);
    let x56: u64 = (x54 >> 8);
    let x57: u8 = ((x56 & (0xff as u64)) as u8);
    let x58: u64 = (x56 >> 8);
    let x59: u8 = ((x58 & (0xff as u64)) as u8);
    let x60: u64 = (x58 >> 8);
    let x61: u8 = ((x60 & (0xff as u64)) as u8);
    let x62: u8 = ((x60 >> 8) as u8);
    let x63: u8 = ((x2 & (0xff as u64)) as u8);
    let x64: u64 = (x2 >> 8);
    let x65: u8 = ((x64 & (0xff as u64)) as u8);
    let x66: u64 = (x64 >> 8);
    let x67: u8 = ((x66 & (0xff as u64)) as u8);
    let x68: u64 = (x66 >> 8);
    let x69: u8 = ((x68 & (0xff as u64)) as u8);
    let x70: u64 = (x68 >> 8);
    let x71: u8 = ((x70 & (0xff as u64)) as u8);
    let x72: u64 = (x70 >> 8);
    let x73: u8 = ((x72 & (0xff as u64)) as u8);
    let x74: u64 = (x72 >> 8);
    let x75: u8 = ((x74 & (0xff as u64)) as u8);
    let x76: u8 = ((x74 >> 8) as u8);
    let x77: u8 = ((x1 & (0xff as u64)) as u8);
    let x78: u64 = (x1 >> 8);
    let x79: u8 = ((x78 & (0xff as u64)) as u8);
    let x80: u64 = (x78 >> 8);
    let x81: u8 = ((x80 & (0xff as u64)) as u8);
    let x82: u64 = (x80 >> 8);
    let x83: u8 = ((x82 & (0xff as u64)) as u8);
    let x84: u64 = (x82 >> 8);
    let x85: u8 = ((x84 & (0xff as u64)) as u8);
    let x86: u64 = (x84 >> 8);
    let x87: u8 = ((x86 & (0xff as u64)) as u8);
    let x88: u64 = (x86 >> 8);
    let x89: u8 = ((x88 & (0xff as u64)) as u8);
    let x90: u8 = ((x88 >> 8) as u8);
    out1[0] = x7;
    out1[1] = x9;
    out1[2] = x11;
    out1[3] = x13;
    out1[4] = x15;
    out1[5] = x17;
    out1[6] = x19;
    out1[7] = x20;
    out1[8] = x21;
    out1[9] = x23;
    out1[10] = x25;
    out1[11] = x27;
    out1[12] = x29;
    out1[13] = x31;
    out1[14] = x33;
    out1[15] = x34;
    out1[16] = x35;
    out1[17] = x37;
    out1[18] = x39;
    out1[19] = x41;
    out1[20] = x43;
    out1[21] = x45;
    out1[22] = x47;
    out1[23] = x48;
    out1[24] = x49;
    out1[25] = x51;
    out1[26] = x53;
    out1[27] = x55;
    out1[28] = x57;
    out1[29] = x59;
    out1[30] = x61;
    out1[31] = x62;
    out1[32] = x63;
    out1[33] = x65;
    out1[34] = x67;
    out1[35] = x69;
    out1[36] = x71;
    out1[37] = x73;
    out1[38] = x75;
    out1[39] = x76;
    out1[40] = x77;
    out1[41] = x79;
    out1[42] = x81;
    out1[43] = x83;
    out1[44] = x85;
    out1[45] = x87;
    out1[46] = x89;
    out1[47] = x90;
    out1
}
#[doc = " The function fiat_p384_from_bytes deserializes a field element NOT in the Montgomery domain from bytes in little-endian order."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ bytes_eval arg1 < m"]
#[doc = " Postconditions:"]
#[doc = "   eval out1 mod m = bytes_eval arg1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [[0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff], [0x0 ~> 0xff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[inline]
pub const fn fiat_p384_from_bytes(arg1: &[u8; 48]) -> [u64; 6] {
    let mut out1: [u64; 6] = [0; 6];
    let x1: u64 = (((arg1[47]) as u64) << 56);
    let x2: u64 = (((arg1[46]) as u64) << 48);
    let x3: u64 = (((arg1[45]) as u64) << 40);
    let x4: u64 = (((arg1[44]) as u64) << 32);
    let x5: u64 = (((arg1[43]) as u64) << 24);
    let x6: u64 = (((arg1[42]) as u64) << 16);
    let x7: u64 = (((arg1[41]) as u64) << 8);
    let x8: u8 = (arg1[40]);
    let x9: u64 = (((arg1[39]) as u64) << 56);
    let x10: u64 = (((arg1[38]) as u64) << 48);
    let x11: u64 = (((arg1[37]) as u64) << 40);
    let x12: u64 = (((arg1[36]) as u64) << 32);
    let x13: u64 = (((arg1[35]) as u64) << 24);
    let x14: u64 = (((arg1[34]) as u64) << 16);
    let x15: u64 = (((arg1[33]) as u64) << 8);
    let x16: u8 = (arg1[32]);
    let x17: u64 = (((arg1[31]) as u64) << 56);
    let x18: u64 = (((arg1[30]) as u64) << 48);
    let x19: u64 = (((arg1[29]) as u64) << 40);
    let x20: u64 = (((arg1[28]) as u64) << 32);
    let x21: u64 = (((arg1[27]) as u64) << 24);
    let x22: u64 = (((arg1[26]) as u64) << 16);
    let x23: u64 = (((arg1[25]) as u64) << 8);
    let x24: u8 = (arg1[24]);
    let x25: u64 = (((arg1[23]) as u64) << 56);
    let x26: u64 = (((arg1[22]) as u64) << 48);
    let x27: u64 = (((arg1[21]) as u64) << 40);
    let x28: u64 = (((arg1[20]) as u64) << 32);
    let x29: u64 = (((arg1[19]) as u64) << 24);
    let x30: u64 = (((arg1[18]) as u64) << 16);
    let x31: u64 = (((arg1[17]) as u64) << 8);
    let x32: u8 = (arg1[16]);
    let x33: u64 = (((arg1[15]) as u64) << 56);
    let x34: u64 = (((arg1[14]) as u64) << 48);
    let x35: u64 = (((arg1[13]) as u64) << 40);
    let x36: u64 = (((arg1[12]) as u64) << 32);
    let x37: u64 = (((arg1[11]) as u64) << 24);
    let x38: u64 = (((arg1[10]) as u64) << 16);
    let x39: u64 = (((arg1[9]) as u64) << 8);
    let x40: u8 = (arg1[8]);
    let x41: u64 = (((arg1[7]) as u64) << 56);
    let x42: u64 = (((arg1[6]) as u64) << 48);
    let x43: u64 = (((arg1[5]) as u64) << 40);
    let x44: u64 = (((arg1[4]) as u64) << 32);
    let x45: u64 = (((arg1[3]) as u64) << 24);
    let x46: u64 = (((arg1[2]) as u64) << 16);
    let x47: u64 = (((arg1[1]) as u64) << 8);
    let x48: u8 = (arg1[0]);
    let x49: u64 = (x47 + (x48 as u64));
    let x50: u64 = (x46 + x49);
    let x51: u64 = (x45 + x50);
    let x52: u64 = (x44 + x51);
    let x53: u64 = (x43 + x52);
    let x54: u64 = (x42 + x53);
    let x55: u64 = (x41 + x54);
    let x56: u64 = (x39 + (x40 as u64));
    let x57: u64 = (x38 + x56);
    let x58: u64 = (x37 + x57);
    let x59: u64 = (x36 + x58);
    let x60: u64 = (x35 + x59);
    let x61: u64 = (x34 + x60);
    let x62: u64 = (x33 + x61);
    let x63: u64 = (x31 + (x32 as u64));
    let x64: u64 = (x30 + x63);
    let x65: u64 = (x29 + x64);
    let x66: u64 = (x28 + x65);
    let x67: u64 = (x27 + x66);
    let x68: u64 = (x26 + x67);
    let x69: u64 = (x25 + x68);
    let x70: u64 = (x23 + (x24 as u64));
    let x71: u64 = (x22 + x70);
    let x72: u64 = (x21 + x71);
    let x73: u64 = (x20 + x72);
    let x74: u64 = (x19 + x73);
    let x75: u64 = (x18 + x74);
    let x76: u64 = (x17 + x75);
    let x77: u64 = (x15 + (x16 as u64));
    let x78: u64 = (x14 + x77);
    let x79: u64 = (x13 + x78);
    let x80: u64 = (x12 + x79);
    let x81: u64 = (x11 + x80);
    let x82: u64 = (x10 + x81);
    let x83: u64 = (x9 + x82);
    let x84: u64 = (x7 + (x8 as u64));
    let x85: u64 = (x6 + x84);
    let x86: u64 = (x5 + x85);
    let x87: u64 = (x4 + x86);
    let x88: u64 = (x3 + x87);
    let x89: u64 = (x2 + x88);
    let x90: u64 = (x1 + x89);
    out1[0] = x55;
    out1[1] = x62;
    out1[2] = x69;
    out1[3] = x76;
    out1[4] = x83;
    out1[5] = x90;
    out1
}
#[doc = " The function fiat_p384_set_one returns the field element one in the Montgomery domain."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) mod m = 1 mod m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[inline]
pub const fn fiat_p384_set_one() -> fiat_p384_montgomery_domain_field_element {
    let mut out1: fiat_p384_montgomery_domain_field_element = [0; 6];
    out1[0] = 0xffffffff00000001;
    out1[1] = 0xffffffff;
    out1[2] = (0x1 as u64);
    out1[3] = (0x0 as u64);
    out1[4] = (0x0 as u64);
    out1[5] = (0x0 as u64);
    out1
}
#[doc = " The function fiat_p384_msat returns the saturated representation of the prime modulus."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   twos_complement_eval out1 = m"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[inline]
pub const fn fiat_p384_msat() -> [u64; 7] {
    let mut out1: [u64; 7] = [0; 7];
    out1[0] = 0xffffffff;
    out1[1] = 0xffffffff00000000;
    out1[2] = 0xfffffffffffffffe;
    out1[3] = 0xffffffffffffffff;
    out1[4] = 0xffffffffffffffff;
    out1[5] = 0xffffffffffffffff;
    out1[6] = (0x0 as u64);
    out1
}
#[doc = " The function fiat_p384_divstep computes a divstep."]
#[doc = ""]
#[doc = " Preconditions:"]
#[doc = "   0 ≤ eval arg4 < m"]
#[doc = "   0 ≤ eval arg5 < m"]
#[doc = " Postconditions:"]
#[doc = "   out1 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then 1 - arg1 else 1 + arg1)"]
#[doc = "   twos_complement_eval out2 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then twos_complement_eval arg3 else twos_complement_eval arg2)"]
#[doc = "   twos_complement_eval out3 = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then ⌊(twos_complement_eval arg3 - twos_complement_eval arg2) / 2⌋ else ⌊(twos_complement_eval arg3 + (twos_complement_eval arg3 mod 2) * twos_complement_eval arg2) / 2⌋)"]
#[doc = "   eval (from_montgomery out4) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (2 * eval (from_montgomery arg5)) mod m else (2 * eval (from_montgomery arg4)) mod m)"]
#[doc = "   eval (from_montgomery out5) mod m = (if 0 < arg1 ∧ (twos_complement_eval arg3) is odd then (eval (from_montgomery arg4) - eval (from_montgomery arg4)) mod m else (eval (from_montgomery arg5) + (twos_complement_eval arg3 mod 2) * eval (from_montgomery arg4)) mod m)"]
#[doc = "   0 ≤ eval out5 < m"]
#[doc = "   0 ≤ eval out5 < m"]
#[doc = "   0 ≤ eval out2 < m"]
#[doc = "   0 ≤ eval out3 < m"]
#[doc = ""]
#[doc = " Input Bounds:"]
#[doc = "   arg1: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   arg2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   arg3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   arg4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   arg5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = " Output Bounds:"]
#[doc = "   out1: [0x0 ~> 0xffffffffffffffff]"]
#[doc = "   out2: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   out3: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   out4: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[doc = "   out5: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[inline]
pub const fn fiat_p384_divstep(
    arg1: u64,
    arg2: &[u64; 7],
    arg3: &[u64; 7],
    arg4: &[u64; 6],
    arg5: &[u64; 6],
) -> (u64, [u64; 7], [u64; 7], [u64; 6], [u64; 6]) {
    let mut out1: u64 = 0;
    let mut out2: [u64; 7] = [0; 7];
    let mut out3: [u64; 7] = [0; 7];
    let mut out4: [u64; 6] = [0; 6];
    let mut out5: [u64; 6] = [0; 6];
    let mut x1: u64 = 0;
    let mut x2: fiat_p384_u1 = 0;
    let (x1, x2) = fiat_p384_addcarryx_u64(0x0, (!arg1), (0x1 as u64));
    let x3: fiat_p384_u1 =
        (((x1 >> 63) as fiat_p384_u1) & (((arg3[0]) & (0x1 as u64)) as fiat_p384_u1));
    let mut x4: u64 = 0;
    let mut x5: fiat_p384_u1 = 0;
    let (x4, x5) = fiat_p384_addcarryx_u64(0x0, (!arg1), (0x1 as u64));
    let mut x6: u64 = 0;
    let (x6) = fiat_p384_cmovznz_u64(x3, arg1, x4);
    let mut x7: u64 = 0;
    let (x7) = fiat_p384_cmovznz_u64(x3, (arg2[0]), (arg3[0]));
    let mut x8: u64 = 0;
    let (x8) = fiat_p384_cmovznz_u64(x3, (arg2[1]), (arg3[1]));
    let mut x9: u64 = 0;
    let (x9) = fiat_p384_cmovznz_u64(x3, (arg2[2]), (arg3[2]));
    let mut x10: u64 = 0;
    let (x10) = fiat_p384_cmovznz_u64(x3, (arg2[3]), (arg3[3]));
    let mut x11: u64 = 0;
    let (x11) = fiat_p384_cmovznz_u64(x3, (arg2[4]), (arg3[4]));
    let mut x12: u64 = 0;
    let (x12) = fiat_p384_cmovznz_u64(x3, (arg2[5]), (arg3[5]));
    let mut x13: u64 = 0;
    let (x13) = fiat_p384_cmovznz_u64(x3, (arg2[6]), (arg3[6]));
    let mut x14: u64 = 0;
    let mut x15: fiat_p384_u1 = 0;
    let (x14, x15) = fiat_p384_addcarryx_u64(0x0, (0x1 as u64), (!(arg2[0])));
    let mut x16: u64 = 0;
    let mut x17: fiat_p384_u1 = 0;
    let (x16, x17) = fiat_p384_addcarryx_u64(x15, (0x0 as u64), (!(arg2[1])));
    let mut x18: u64 = 0;
    let mut x19: fiat_p384_u1 = 0;
    let (x18, x19) = fiat_p384_addcarryx_u64(x17, (0x0 as u64), (!(arg2[2])));
    let mut x20: u64 = 0;
    let mut x21: fiat_p384_u1 = 0;
    let (x20, x21) = fiat_p384_addcarryx_u64(x19, (0x0 as u64), (!(arg2[3])));
    let mut x22: u64 = 0;
    let mut x23: fiat_p384_u1 = 0;
    let (x22, x23) = fiat_p384_addcarryx_u64(x21, (0x0 as u64), (!(arg2[4])));
    let mut x24: u64 = 0;
    let mut x25: fiat_p384_u1 = 0;
    let (x24, x25) = fiat_p384_addcarryx_u64(x23, (0x0 as u64), (!(arg2[5])));
    let mut x26: u64 = 0;
    let mut x27: fiat_p384_u1 = 0;
    let (x26, x27) = fiat_p384_addcarryx_u64(x25, (0x0 as u64), (!(arg2[6])));
    let mut x28: u64 = 0;
    let (x28) = fiat_p384_cmovznz_u64(x3, (arg3[0]), x14);
    let mut x29: u64 = 0;
    let (x29) = fiat_p384_cmovznz_u64(x3, (arg3[1]), x16);
    let mut x30: u64 = 0;
    let (x30) = fiat_p384_cmovznz_u64(x3, (arg3[2]), x18);
    let mut x31: u64 = 0;
    let (x31) = fiat_p384_cmovznz_u64(x3, (arg3[3]), x20);
    let mut x32: u64 = 0;
    let (x32) = fiat_p384_cmovznz_u64(x3, (arg3[4]), x22);
    let mut x33: u64 = 0;
    let (x33) = fiat_p384_cmovznz_u64(x3, (arg3[5]), x24);
    let mut x34: u64 = 0;
    let (x34) = fiat_p384_cmovznz_u64(x3, (arg3[6]), x26);
    let mut x35: u64 = 0;
    let (x35) = fiat_p384_cmovznz_u64(x3, (arg4[0]), (arg5[0]));
    let mut x36: u64 = 0;
    let (x36) = fiat_p384_cmovznz_u64(x3, (arg4[1]), (arg5[1]));
    let mut x37: u64 = 0;
    let (x37) = fiat_p384_cmovznz_u64(x3, (arg4[2]), (arg5[2]));
    let mut x38: u64 = 0;
    let (x38) = fiat_p384_cmovznz_u64(x3, (arg4[3]), (arg5[3]));
    let mut x39: u64 = 0;
    let (x39) = fiat_p384_cmovznz_u64(x3, (arg4[4]), (arg5[4]));
    let mut x40: u64 = 0;
    let (x40) = fiat_p384_cmovznz_u64(x3, (arg4[5]), (arg5[5]));
    let mut x41: u64 = 0;
    let mut x42: fiat_p384_u1 = 0;
    let (x41, x42) = fiat_p384_addcarryx_u64(0x0, x35, x35);
    let mut x43: u64 = 0;
    let mut x44: fiat_p384_u1 = 0;
    let (x43, x44) = fiat_p384_addcarryx_u64(x42, x36, x36);
    let mut x45: u64 = 0;
    let mut x46: fiat_p384_u1 = 0;
    let (x45, x46) = fiat_p384_addcarryx_u64(x44, x37, x37);
    let mut x47: u64 = 0;
    let mut x48: fiat_p384_u1 = 0;
    let (x47, x48) = fiat_p384_addcarryx_u64(x46, x38, x38);
    let mut x49: u64 = 0;
    let mut x50: fiat_p384_u1 = 0;
    let (x49, x50) = fiat_p384_addcarryx_u64(x48, x39, x39);
    let mut x51: u64 = 0;
    let mut x52: fiat_p384_u1 = 0;
    let (x51, x52) = fiat_p384_addcarryx_u64(x50, x40, x40);
    let mut x53: u64 = 0;
    let mut x54: fiat_p384_u1 = 0;
    let (x53, x54) = fiat_p384_subborrowx_u64(0x0, x41, 0xffffffff);
    let mut x55: u64 = 0;
    let mut x56: fiat_p384_u1 = 0;
    let (x55, x56) = fiat_p384_subborrowx_u64(x54, x43, 0xffffffff00000000);
    let mut x57: u64 = 0;
    let mut x58: fiat_p384_u1 = 0;
    let (x57, x58) = fiat_p384_subborrowx_u64(x56, x45, 0xfffffffffffffffe);
    let mut x59: u64 = 0;
    let mut x60: fiat_p384_u1 = 0;
    let (x59, x60) = fiat_p384_subborrowx_u64(x58, x47, 0xffffffffffffffff);
    let mut x61: u64 = 0;
    let mut x62: fiat_p384_u1 = 0;
    let (x61, x62) = fiat_p384_subborrowx_u64(x60, x49, 0xffffffffffffffff);
    let mut x63: u64 = 0;
    let mut x64: fiat_p384_u1 = 0;
    let (x63, x64) = fiat_p384_subborrowx_u64(x62, x51, 0xffffffffffffffff);
    let mut x65: u64 = 0;
    let mut x66: fiat_p384_u1 = 0;
    let (x65, x66) = fiat_p384_subborrowx_u64(x64, (x52 as u64), (0x0 as u64));
    let x67: u64 = (arg4[5]);
    let x68: u64 = (arg4[4]);
    let x69: u64 = (arg4[3]);
    let x70: u64 = (arg4[2]);
    let x71: u64 = (arg4[1]);
    let x72: u64 = (arg4[0]);
    let mut x73: u64 = 0;
    let mut x74: fiat_p384_u1 = 0;
    let (x73, x74) = fiat_p384_subborrowx_u64(0x0, (0x0 as u64), x72);
    let mut x75: u64 = 0;
    let mut x76: fiat_p384_u1 = 0;
    let (x75, x76) = fiat_p384_subborrowx_u64(x74, (0x0 as u64), x71);
    let mut x77: u64 = 0;
    let mut x78: fiat_p384_u1 = 0;
    let (x77, x78) = fiat_p384_subborrowx_u64(x76, (0x0 as u64), x70);
    let mut x79: u64 = 0;
    let mut x80: fiat_p384_u1 = 0;
    let (x79, x80) = fiat_p384_subborrowx_u64(x78, (0x0 as u64), x69);
    let mut x81: u64 = 0;
    let mut x82: fiat_p384_u1 = 0;
    let (x81, x82) = fiat_p384_subborrowx_u64(x80, (0x0 as u64), x68);
    let mut x83: u64 = 0;
    let mut x84: fiat_p384_u1 = 0;
    let (x83, x84) = fiat_p384_subborrowx_u64(x82, (0x0 as u64), x67);
    let mut x85: u64 = 0;
    let (x85) = fiat_p384_cmovznz_u64(x84, (0x0 as u64), 0xffffffffffffffff);
    let mut x86: u64 = 0;
    let mut x87: fiat_p384_u1 = 0;
    let (x86, x87) = fiat_p384_addcarryx_u64(0x0, x73, (x85 & 0xffffffff));
    let mut x88: u64 = 0;
    let mut x89: fiat_p384_u1 = 0;
    let (x88, x89) = fiat_p384_addcarryx_u64(x87, x75, (x85 & 0xffffffff00000000));
    let mut x90: u64 = 0;
    let mut x91: fiat_p384_u1 = 0;
    let (x90, x91) = fiat_p384_addcarryx_u64(x89, x77, (x85 & 0xfffffffffffffffe));
    let mut x92: u64 = 0;
    let mut x93: fiat_p384_u1 = 0;
    let (x92, x93) = fiat_p384_addcarryx_u64(x91, x79, x85);
    let mut x94: u64 = 0;
    let mut x95: fiat_p384_u1 = 0;
    let (x94, x95) = fiat_p384_addcarryx_u64(x93, x81, x85);
    let mut x96: u64 = 0;
    let mut x97: fiat_p384_u1 = 0;
    let (x96, x97) = fiat_p384_addcarryx_u64(x95, x83, x85);
    let mut x98: u64 = 0;
    let (x98) = fiat_p384_cmovznz_u64(x3, (arg5[0]), x86);
    let mut x99: u64 = 0;
    let (x99) = fiat_p384_cmovznz_u64(x3, (arg5[1]), x88);
    let mut x100: u64 = 0;
    let (x100) = fiat_p384_cmovznz_u64(x3, (arg5[2]), x90);
    let mut x101: u64 = 0;
    let (x101) = fiat_p384_cmovznz_u64(x3, (arg5[3]), x92);
    let mut x102: u64 = 0;
    let (x102) = fiat_p384_cmovznz_u64(x3, (arg5[4]), x94);
    let mut x103: u64 = 0;
    let (x103) = fiat_p384_cmovznz_u64(x3, (arg5[5]), x96);
    let x104: fiat_p384_u1 = ((x28 & (0x1 as u64)) as fiat_p384_u1);
    let mut x105: u64 = 0;
    let (x105) = fiat_p384_cmovznz_u64(x104, (0x0 as u64), x7);
    let mut x106: u64 = 0;
    let (x106) = fiat_p384_cmovznz_u64(x104, (0x0 as u64), x8);
    let mut x107: u64 = 0;
    let (x107) = fiat_p384_cmovznz_u64(x104, (0x0 as u64), x9);
    let mut x108: u64 = 0;
    let (x108) = fiat_p384_cmovznz_u64(x104, (0x0 as u64), x10);
    let mut x109: u64 = 0;
    let (x109) = fiat_p384_cmovznz_u64(x104, (0x0 as u64), x11);
    let mut x110: u64 = 0;
    let (x110) = fiat_p384_cmovznz_u64(x104, (0x0 as u64), x12);
    let mut x111: u64 = 0;
    let (x111) = fiat_p384_cmovznz_u64(x104, (0x0 as u64), x13);
    let mut x112: u64 = 0;
    let mut x113: fiat_p384_u1 = 0;
    let (x112, x113) = fiat_p384_addcarryx_u64(0x0, x28, x105);
    let mut x114: u64 = 0;
    let mut x115: fiat_p384_u1 = 0;
    let (x114, x115) = fiat_p384_addcarryx_u64(x113, x29, x106);
    let mut x116: u64 = 0;
    let mut x117: fiat_p384_u1 = 0;
    let (x116, x117) = fiat_p384_addcarryx_u64(x115, x30, x107);
    let mut x118: u64 = 0;
    let mut x119: fiat_p384_u1 = 0;
    let (x118, x119) = fiat_p384_addcarryx_u64(x117, x31, x108);
    let mut x120: u64 = 0;
    let mut x121: fiat_p384_u1 = 0;
    let (x120, x121) = fiat_p384_addcarryx_u64(x119, x32, x109);
    let mut x122: u64 = 0;
    let mut x123: fiat_p384_u1 = 0;
    let (x122, x123) = fiat_p384_addcarryx_u64(x121, x33, x110);
    let mut x124: u64 = 0;
    let mut x125: fiat_p384_u1 = 0;
    let (x124, x125) = fiat_p384_addcarryx_u64(x123, x34, x111);
    let mut x126: u64 = 0;
    let (x126) = fiat_p384_cmovznz_u64(x104, (0x0 as u64), x35);
    let mut x127: u64 = 0;
    let (x127) = fiat_p384_cmovznz_u64(x104, (0x0 as u64), x36);
    let mut x128: u64 = 0;
    let (x128) = fiat_p384_cmovznz_u64(x104, (0x0 as u64), x37);
    let mut x129: u64 = 0;
    let (x129) = fiat_p384_cmovznz_u64(x104, (0x0 as u64), x38);
    let mut x130: u64 = 0;
    let (x130) = fiat_p384_cmovznz_u64(x104, (0x0 as u64), x39);
    let mut x131: u64 = 0;
    let (x131) = fiat_p384_cmovznz_u64(x104, (0x0 as u64), x40);
    let mut x132: u64 = 0;
    let mut x133: fiat_p384_u1 = 0;
    let (x132, x133) = fiat_p384_addcarryx_u64(0x0, x98, x126);
    let mut x134: u64 = 0;
    let mut x135: fiat_p384_u1 = 0;
    let (x134, x135) = fiat_p384_addcarryx_u64(x133, x99, x127);
    let mut x136: u64 = 0;
    let mut x137: fiat_p384_u1 = 0;
    let (x136, x137) = fiat_p384_addcarryx_u64(x135, x100, x128);
    let mut x138: u64 = 0;
    let mut x139: fiat_p384_u1 = 0;
    let (x138, x139) = fiat_p384_addcarryx_u64(x137, x101, x129);
    let mut x140: u64 = 0;
    let mut x141: fiat_p384_u1 = 0;
    let (x140, x141) = fiat_p384_addcarryx_u64(x139, x102, x130);
    let mut x142: u64 = 0;
    let mut x143: fiat_p384_u1 = 0;
    let (x142, x143) = fiat_p384_addcarryx_u64(x141, x103, x131);
    let mut x144: u64 = 0;
    let mut x145: fiat_p384_u1 = 0;
    let (x144, x145) = fiat_p384_subborrowx_u64(0x0, x132, 0xffffffff);
    let mut x146: u64 = 0;
    let mut x147: fiat_p384_u1 = 0;
    let (x146, x147) = fiat_p384_subborrowx_u64(x145, x134, 0xffffffff00000000);
    let mut x148: u64 = 0;
    let mut x149: fiat_p384_u1 = 0;
    let (x148, x149) = fiat_p384_subborrowx_u64(x147, x136, 0xfffffffffffffffe);
    let mut x150: u64 = 0;
    let mut x151: fiat_p384_u1 = 0;
    let (x150, x151) = fiat_p384_subborrowx_u64(x149, x138, 0xffffffffffffffff);
    let mut x152: u64 = 0;
    let mut x153: fiat_p384_u1 = 0;
    let (x152, x153) = fiat_p384_subborrowx_u64(x151, x140, 0xffffffffffffffff);
    let mut x154: u64 = 0;
    let mut x155: fiat_p384_u1 = 0;
    let (x154, x155) = fiat_p384_subborrowx_u64(x153, x142, 0xffffffffffffffff);
    let mut x156: u64 = 0;
    let mut x157: fiat_p384_u1 = 0;
    let (x156, x157) = fiat_p384_subborrowx_u64(x155, (x143 as u64), (0x0 as u64));
    let mut x158: u64 = 0;
    let mut x159: fiat_p384_u1 = 0;
    let (x158, x159) = fiat_p384_addcarryx_u64(0x0, x6, (0x1 as u64));
    let x160: u64 = ((x112 >> 1) | ((x114 << 63) & 0xffffffffffffffff));
    let x161: u64 = ((x114 >> 1) | ((x116 << 63) & 0xffffffffffffffff));
    let x162: u64 = ((x116 >> 1) | ((x118 << 63) & 0xffffffffffffffff));
    let x163: u64 = ((x118 >> 1) | ((x120 << 63) & 0xffffffffffffffff));
    let x164: u64 = ((x120 >> 1) | ((x122 << 63) & 0xffffffffffffffff));
    let x165: u64 = ((x122 >> 1) | ((x124 << 63) & 0xffffffffffffffff));
    let x166: u64 = ((x124 & 0x8000000000000000) | (x124 >> 1));
    let mut x167: u64 = 0;
    let (x167) = fiat_p384_cmovznz_u64(x66, x53, x41);
    let mut x168: u64 = 0;
    let (x168) = fiat_p384_cmovznz_u64(x66, x55, x43);
    let mut x169: u64 = 0;
    let (x169) = fiat_p384_cmovznz_u64(x66, x57, x45);
    let mut x170: u64 = 0;
    let (x170) = fiat_p384_cmovznz_u64(x66, x59, x47);
    let mut x171: u64 = 0;
    let (x171) = fiat_p384_cmovznz_u64(x66, x61, x49);
    let mut x172: u64 = 0;
    let (x172) = fiat_p384_cmovznz_u64(x66, x63, x51);
    let mut x173: u64 = 0;
    let (x173) = fiat_p384_cmovznz_u64(x157, x144, x132);
    let mut x174: u64 = 0;
    let (x174) = fiat_p384_cmovznz_u64(x157, x146, x134);
    let mut x175: u64 = 0;
    let (x175) = fiat_p384_cmovznz_u64(x157, x148, x136);
    let mut x176: u64 = 0;
    let (x176) = fiat_p384_cmovznz_u64(x157, x150, x138);
    let mut x177: u64 = 0;
    let (x177) = fiat_p384_cmovznz_u64(x157, x152, x140);
    let mut x178: u64 = 0;
    let (x178) = fiat_p384_cmovznz_u64(x157, x154, x142);
    out1 = x158;
    out2[0] = x7;
    out2[1] = x8;
    out2[2] = x9;
    out2[3] = x10;
    out2[4] = x11;
    out2[5] = x12;
    out2[6] = x13;
    out3[0] = x160;
    out3[1] = x161;
    out3[2] = x162;
    out3[3] = x163;
    out3[4] = x164;
    out3[5] = x165;
    out3[6] = x166;
    out4[0] = x167;
    out4[1] = x168;
    out4[2] = x169;
    out4[3] = x170;
    out4[4] = x171;
    out4[5] = x172;
    out5[0] = x173;
    out5[1] = x174;
    out5[2] = x175;
    out5[3] = x176;
    out5[4] = x177;
    out5[5] = x178;
    (out1, out2, out3, out4, out5)
}
#[doc = " The function fiat_p384_divstep_precomp returns the precomputed value for Bernstein-Yang-inversion (in montgomery form)."]
#[doc = ""]
#[doc = " Postconditions:"]
#[doc = "   eval (from_montgomery out1) = ⌊(m - 1) / 2⌋^(if ⌊log2 m⌋ + 1 < 46 then ⌊(49 * (⌊log2 m⌋ + 1) + 80) / 17⌋ else ⌊(49 * (⌊log2 m⌋ + 1) + 57) / 17⌋)"]
#[doc = "   0 ≤ eval out1 < m"]
#[doc = ""]
#[doc = " Output Bounds:"]
#[doc = "   out1: [[0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff], [0x0 ~> 0xffffffffffffffff]]"]
#[inline]
pub const fn fiat_p384_divstep_precomp() -> [u64; 6] {
    let mut out1: [u64; 6] = [0; 6];
    out1[0] = 0xfff69400fff18fff;
    out1[1] = 0x2b7feffffd3ff;
    out1[2] = 0xfffedbfffffe97ff;
    out1[3] = 0x2840000002fff;
    out1[4] = 0x6040000050400;
    out1[5] = 0xfffc480000038000;
    out1
}
