## Direct, unsafe Rust bindings for Linux's `perf_event_open` system call

This crate exports `unsafe` Rust wrappers for Linux system calls for accessing
performance monitoring counters and tracing facilities. This includes:

- the processor's own performance monitoring registers
- kernel counters for things like context switches and page faults
- kernel tracepoints, kprobe, and uprobes
- processor tracing facilities like Intel's Branch Trace Store (BTS)
- hardware breakpoints

This crate provides:

- a Rust wrapper the Linux `perf_event_open` system call
- Rust wrappers for the ioctls you can apply to a file descriptor returned by `perf_event_open`
- bindings for `perf_event_open`'s associated header files, automatically generated by `bindgen`

All functions are direct, `unsafe` wrappers for the underlying calls. They
operate on raw pointers and raw file descriptors.

For a type-safe API for basic functionality, see the [perf-event] crate.

[perf-event]: https://crates.io/crates/perf-event

### Updating the System Call Bindings

The `bindings` module defines Rust equivalents for the types and constants used
by the Linux `perf_event_open` system call and its related ioctls. These are
generated automatically from the kernel's C header files, using [bindgen]. Both
the interface and the underlying functionality are quite complex, and new
features are added at a steady pace. To update the generated bindings:

-   Run the `regenerate.sh` script, found in the same directory as this
    `README.md` file. This runs bindgen and splices its output into the
    `bindings` module's source code, preserving the documentation.

-   Fix the comments in `src/lib.rs` explaining exactly which version of the
    kernel headers you generated the bindings from.

-   Update the crate's major version. Newer versions of the kernel headers may
    add fields to structs, which is a breaking change. (As explained in the
    module documentation, properly written user crates should not be affected,
    but it seems unnecessary to risk `cargo update` breaking builds. When users
    need new functionality from the bindings, they can update the major version
    number of this crate they request.)

[bindgen]: https://crates.io/crates/bindgen
