/*
 * Decompiled with CFR 0.152.
 */
package uk.me.nxg.unity;

import java.util.List;
import uk.me.nxg.unity.Dimensions;
import uk.me.nxg.unity.FunctionDefinition;
import uk.me.nxg.unity.FunctionDefinitionMap;
import uk.me.nxg.unity.OneUnit;
import uk.me.nxg.unity.SimpleUnit;
import uk.me.nxg.unity.Syntax;
import uk.me.nxg.unity.UnitDefinition;
import uk.me.nxg.unity.UnitDefinitionMap;
import uk.me.nxg.unity.UnitExpr;
import uk.me.nxg.unity.UnitParserException;
import uk.me.nxg.unity.UnitWriterDebugging;
import uk.me.nxg.unity.UnwritableExpression;

public class FunctionOfUnit
extends OneUnit {
    private final String functionName;
    private final FunctionDefinition functionDefinition;
    private final UnitExpr operand;
    private FunctionDefinition logFunction = null;

    FunctionOfUnit(String string, List<OneUnit> list) throws IllegalArgumentException {
        this(1.0f, string, null, new UnitExpr(0.0, list, null));
    }

    FunctionOfUnit(String string, List<OneUnit> list, double d) throws IllegalArgumentException {
        this(1.0f, string, null, new UnitExpr(d, list, null));
    }

    FunctionOfUnit(FunctionDefinition functionDefinition, List<OneUnit> list) throws IllegalArgumentException {
        this(1.0f, null, functionDefinition, new UnitExpr(0.0, list, null));
    }

    FunctionOfUnit(FunctionDefinition functionDefinition, List<OneUnit> list, double d) throws IllegalArgumentException {
        this(1.0f, null, functionDefinition, new UnitExpr(d, list, null));
    }

    private FunctionOfUnit(float f, String string, FunctionDefinition functionDefinition, UnitExpr unitExpr) {
        super(f, false);
        if (string == null && functionDefinition == null) {
            throw new IllegalArgumentException("FunctionOfUnit(float,String,FunctionDefinition,UnitExpr): either argument 2 or 3 must be non-null");
        }
        if (unitExpr == null) {
            throw new IllegalArgumentException("FunctionOfUnit(float,String,FunctionDefinition,UnitExpr): argument 4 must be non-null");
        }
        this.functionName = string;
        this.functionDefinition = functionDefinition;
        this.operand = unitExpr;
        assert (!(this.isQuoted() || this.functionName == null && this.functionDefinition == null));
    }

    @Override
    public int getPrefix() {
        return 0;
    }

    @Override
    public Dimensions getDimensions() {
        return Dimensions.unity();
    }

    @Override
    public UnitDefinition getBaseUnitDefinition() {
        return this.operand.getUnit(0).getBaseUnitDefinition();
    }

    @Override
    public String getBaseUnitName() {
        return this.operand.getUnit(0).getBaseUnitName();
    }

    @Override
    public String getBaseUnitString() {
        return this.operand.getUnit(0).getBaseUnitString();
    }

    @Override
    UnitDefinitionMap.Resolver getUnitResolver() {
        return this.operand.getUnitResolver();
    }

    public OneUnit getUnit(UnitDefinition unitDefinition) {
        return this.operand.getUnit(unitDefinition);
    }

    @Override
    public boolean isRecognisedUnit(Syntax syntax) {
        return this.functionDefinition != null && this.operand.allUnitsRecognised(syntax);
    }

    @Override
    public boolean isRecognisedUnit() {
        return this.functionDefinition != null && this.operand.allUnitsRecognised();
    }

    @Override
    public boolean isRecommendedUnit(Syntax syntax) {
        if (this.functionDefinition == null) {
            return false;
        }
        return this.operand.allUnitsRecommended(syntax);
    }

    @Override
    public boolean satisfiesUsageConstraints(Syntax syntax) {
        return this.operand.allUsageConstraintsSatisfied(syntax);
    }

    @Override
    public String toDebugString() {
        String string = this.functionDefinition == null ? this.functionName : this.functionDefinition.name();
        if (string == null) {
            string = this.functionDefinition.fallbackName();
        }
        assert (string != null) : "toDebugString: function has no name";
        StringBuilder stringBuilder = new StringBuilder(string);
        UnitWriterDebugging unitWriterDebugging = new UnitWriterDebugging(this.operand);
        stringBuilder.append('(').append(unitWriterDebugging.write(false)).append(')');
        if (this.getExponent() != 1.0f) {
            stringBuilder.append('^');
            float f = this.getExponent();
            if ((double)f == Math.floor(f)) {
                stringBuilder.append(Math.round(f));
            } else {
                stringBuilder.append(f);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    @Override
    public String toString(Syntax syntax) {
        try {
            return this.unitString(syntax);
        }
        catch (UnitParserException unitParserException) {
            try {
                return this.unitString(Syntax.FITS);
            }
            catch (Exception exception) {
                throw new AssertionError((Object)("FunctionOfUnit.toString with syntax FITS really should work: " + exception));
            }
        }
    }

    @Override
    public String unitString(Syntax syntax) throws UnwritableExpression {
        String string = syntax == Syntax.CDS ? this.unitStringCDS() : (syntax == Syntax.LATEX ? this.unitStringLaTeX() : this.unitStringText(syntax));
        assert (string != null) : String.format("Unable to construct a unit string for syntax [%s]", new Object[]{syntax});
        return string;
    }

    String unitStringText(Syntax syntax) throws UnwritableExpression {
        String string = null;
        if (this.functionDefinition != null) {
            string = FunctionDefinitionMap.lookupFunctionName(syntax == null ? Syntax.FITS : syntax, this.functionDefinition);
            if (string == null) {
                string = this.functionDefinition.toString();
            }
        } else {
            string = this.functionName;
        }
        assert (string != null) : String.format("Function %s/%s: can't construct unit string", this.functionName, this.functionDefinition);
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('(').append(this.operand.toString(syntax)).append(')');
        return stringBuilder.toString();
    }

    String unitStringLaTeX() throws UnwritableExpression {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\\text{\\ensuremath{");
        if (this.functionDefinition != null) {
            stringBuilder.append(this.functionDefinition.latexForm());
        } else {
            assert (this.functionName != null);
            stringBuilder.append("\\mathop{\\mathrm{").append(this.functionName).append("}}");
        }
        stringBuilder.append('(').append(this.operand.toString(Syntax.LATEX)).append(")}}");
        return stringBuilder.toString();
    }

    String unitStringCDS() throws UnwritableExpression {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.logFunction == null) {
            this.logFunction = FunctionDefinitionMap.lookupFunctionDefinition(Syntax.VOUNITS, "log");
            assert (this.logFunction != null);
        }
        if (this.functionDefinition != null && this.functionDefinition.equals(this.logFunction)) {
            stringBuilder.append('[').append(this.operand.toString(Syntax.CDS)).append(']');
            return stringBuilder.toString();
        }
        throw new UnwritableExpression("CDS syntax can only express log functions, not " + (this.functionDefinition == null ? this.functionName : this.functionDefinition));
    }

    public FunctionDefinition getFunctionDefinition() {
        return this.functionDefinition;
    }

    public String getFunctionName() {
        String string;
        if (this.functionDefinition == null) {
            string = this.functionName;
        } else {
            assert (this.functionDefinition != null);
            string = this.functionDefinition.name();
        }
        return string;
    }

    @Override
    public String getOriginalUnitString() {
        return this.functionName;
    }

    @Override
    OneUnit reciprocate() {
        return new FunctionOfUnit(-this.getExponent(), this.functionName, this.functionDefinition, this.operand);
    }

    @Override
    OneUnit pow(double d) {
        return new FunctionOfUnit((float)d, this.functionName, this.functionDefinition, this.operand);
    }

    @Override
    public int compareTo(OneUnit oneUnit) {
        int n;
        if (oneUnit == this) {
            n = 0;
        } else if (oneUnit instanceof SimpleUnit) {
            n = 1;
        } else {
            FunctionOfUnit functionOfUnit = (FunctionOfUnit)oneUnit;
            if (this.functionDefinition != null) {
                n = functionOfUnit.functionDefinition == null ? -1 : this.functionDefinition.compareTo(functionOfUnit.functionDefinition);
            } else if (functionOfUnit.functionDefinition != null) {
                n = 1;
            } else {
                assert (this.functionName != null && functionOfUnit.functionName != null);
                n = this.functionName.compareTo(functionOfUnit.functionName);
            }
            if (n == 0 && (n = this.operand.compareTo(functionOfUnit.operand)) == 0) {
                double d;
                double d2 = this.getExponent();
                n = d2 == (d = (double)functionOfUnit.getExponent()) ? 0 : (d2 < d ? -1 : 1);
            }
        }
        return n;
    }

    public boolean equals(Object object) {
        if (object instanceof FunctionOfUnit) {
            return this.compareTo((FunctionOfUnit)object) == 0;
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

