/*
 * Decompiled with CFR 0.152.
 */
package adql.query.from;

import adql.db.DBColumn;
import adql.db.DBTable;
import adql.db.DefaultDBTable;
import adql.db.SearchColumnList;
import adql.parser.feature.LanguageFeature;
import adql.query.ADQLIterator;
import adql.query.ADQLObject;
import adql.query.ADQLSet;
import adql.query.IdentifierField;
import adql.query.TextPosition;
import adql.query.from.FromContent;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;

public class ADQLTable
implements ADQLObject,
FromContent {
    public static final LanguageFeature FEATURE = new LanguageFeature(null, "TABLE", false, "Table to query.");
    private String catalog = null;
    private String schema = null;
    private String table;
    private ADQLSet subQuery;
    private String alias = null;
    private byte caseSensitivity = 0;
    private DBTable dbLink = null;
    private TextPosition position = null;

    public ADQLTable(String table) {
        this.setTable(table);
        this.subQuery = null;
    }

    public ADQLTable(String schema, String table) {
        this.setTableName(table);
        this.setSchemaName(schema);
    }

    public ADQLTable(String catalog, String schema, String table) {
        this(schema, table);
        this.setCatalogName(catalog);
    }

    public ADQLTable(ADQLSet query) {
        this.setSubQuery(query);
    }

    public ADQLTable(ADQLTable toCopy) throws Exception {
        this.catalog = toCopy.catalog;
        this.schema = toCopy.schema;
        this.table = toCopy.table;
        this.subQuery = toCopy.subQuery == null ? null : (ADQLSet)toCopy.subQuery.getCopy();
        this.alias = toCopy.alias;
        this.caseSensitivity = toCopy.caseSensitivity;
        this.position = toCopy.position;
    }

    @Override
    public final LanguageFeature getFeatureDescription() {
        return FEATURE;
    }

    protected String normalizeName(String name, IdentifierField field) {
        if (name == null) {
            return null;
        }
        StringBuffer n = new StringBuffer(name);
        n.trimToSize();
        if (n.length() == 0) {
            return null;
        }
        if (n.length() > 1 && n.charAt(0) == '\"' && n.charAt(n.length() - 1) == '\"') {
            n.deleteCharAt(0);
            n.deleteCharAt(n.length() - 1);
            n.trimToSize();
            if (n.length() == 0) {
                return null;
            }
            this.setCaseSensitive(field, true);
        }
        return n.toString();
    }

    @Override
    public final TextPosition getPosition() {
        return this.position;
    }

    @Override
    public final void setPosition(TextPosition pos) {
        this.position = pos;
    }

    public final String getCatalogName() {
        return this.catalog;
    }

    public final void setCatalogName(String catalog) {
        String temp = this.normalizeName(catalog, IdentifierField.CATALOG);
        if (this.catalog == null && temp != null || this.catalog != null && !this.catalog.equalsIgnoreCase(temp)) {
            this.dbLink = null;
        }
        this.catalog = temp;
    }

    public final String getSchemaName() {
        return this.schema;
    }

    public final void setSchemaName(String schema) {
        String temp = this.normalizeName(schema, IdentifierField.SCHEMA);
        if (this.schema == null && temp != null || this.schema != null && !this.schema.equalsIgnoreCase(temp)) {
            this.dbLink = null;
        }
        this.schema = temp;
    }

    public final String getTableName() {
        return this.table;
    }

    public final String getFullTableName() {
        if (this.table == null) {
            return "";
        }
        StringBuffer name = new StringBuffer();
        if (this.catalog != null) {
            if (this.isCaseSensitive(IdentifierField.CATALOG)) {
                name.append('\"').append(this.catalog).append('\"').append('.');
            } else {
                name.append(this.catalog).append('.');
            }
        }
        if (this.schema != null) {
            if (this.isCaseSensitive(IdentifierField.SCHEMA)) {
                name.append('\"').append(this.schema).append('\"').append('.');
            } else {
                name.append(this.schema).append('.');
            }
        }
        if (this.isCaseSensitive(IdentifierField.TABLE)) {
            name.append('\"').append(this.table).append('\"');
        } else {
            name.append(this.table);
        }
        return name.toString();
    }

    public void setTableName(String newTableName) {
        String temp = this.normalizeName(newTableName, IdentifierField.TABLE);
        if (this.table == null && temp != null || this.table != null && !this.table.equalsIgnoreCase(temp)) {
            this.dbLink = null;
        }
        this.table = temp;
        if (this.table != null) {
            this.subQuery = null;
        }
    }

    public final void setTable(String tableRef) {
        String[] parts;
        String[] stringArray = parts = tableRef == null ? null : tableRef.split("\\.");
        if (parts != null && parts.length > 3) {
            return;
        }
        int i = parts == null ? -1 : parts.length - 1;
        this.setTableName(i < 0 ? null : parts[i--]);
        this.setSchemaName(i < 0 ? null : parts[i--]);
        this.setCatalogName(i < 0 ? null : parts[i]);
        if (this.table != null) {
            this.subQuery = null;
        }
    }

    public final ADQLSet getSubQuery() {
        return this.subQuery;
    }

    public final void setSubQuery(ADQLSet query) {
        if (query != null) {
            this.subQuery = query;
            this.catalog = null;
            this.schema = null;
            this.table = null;
            this.dbLink = null;
            this.position = null;
            this.refreshDBLink();
        }
    }

    public final void refreshDBLink() {
        if (this.isSubQuery() && this.hasAlias()) {
            DBColumn[] columns;
            DefaultDBTable dbTable = new DefaultDBTable(this.alias);
            for (DBColumn dbCol : columns = this.subQuery.getResultingColumns()) {
                dbTable.addColumn(dbCol.copy(dbCol.getADQLName(), dbCol.getADQLName(), dbTable));
            }
            this.dbLink = dbTable;
        }
    }

    public final boolean isSubQuery() {
        return this.subQuery != null;
    }

    public final String getAlias() {
        return this.alias;
    }

    public final boolean hasAlias() {
        return this.alias != null;
    }

    public void setAlias(String alias) {
        this.alias = this.normalizeName(alias, IdentifierField.ALIAS);
    }

    public final boolean isCaseSensitive(IdentifierField field) {
        return field.isCaseSensitive(this.caseSensitivity);
    }

    public final void setCaseSensitive(IdentifierField field, boolean sensitive) {
        this.caseSensitivity = field.setCaseSensitive(this.caseSensitivity, sensitive);
    }

    public final boolean isCaseSensitive() {
        return IdentifierField.isFullCaseSensitive(this.caseSensitivity);
    }

    public final void setCaseSensitive(boolean sensitive) {
        this.caseSensitivity = IdentifierField.getFullCaseSensitive(sensitive);
    }

    public final byte getCaseSensitive() {
        return this.caseSensitivity;
    }

    public final void setCaseSensitive(byte sensitivity) {
        this.caseSensitivity = sensitivity;
    }

    public final DBTable getDBLink() {
        return this.dbLink;
    }

    public final void setDBLink(DBTable dbLink) {
        this.dbLink = dbLink;
    }

    @Override
    public SearchColumnList getDBColumns() {
        SearchColumnList list = new SearchColumnList();
        if (this.isSubQuery() && this.dbLink == null) {
            this.refreshDBLink();
        }
        if (this.dbLink != null) {
            for (DBColumn dbCol : this.dbLink) {
                list.add(dbCol);
            }
        }
        return list;
    }

    @Override
    public List<ADQLTable> getTables() {
        ArrayList<ADQLTable> tables = new ArrayList<ADQLTable>();
        tables.add(this);
        return tables;
    }

    @Override
    public List<ADQLTable> getTablesByAlias(String alias, boolean caseSensitive) {
        ArrayList<ADQLTable> tables = new ArrayList<ADQLTable>();
        if (this.hasAlias()) {
            if (!caseSensitive) {
                if (this.getAlias().equalsIgnoreCase(alias)) {
                    tables.add(this);
                }
            } else if (IdentifierField.ALIAS.isCaseSensitive(this.caseSensitivity)) {
                if (this.getAlias().equals(alias)) {
                    tables.add(this);
                }
            } else if (this.getAlias().toLowerCase().equals(alias)) {
                tables.add(this);
            }
        }
        return tables;
    }

    @Override
    public ADQLObject getCopy() throws Exception {
        return new ADQLTable(this);
    }

    @Override
    public String getName() {
        return this.hasAlias() ? this.alias : (this.isSubQuery() ? "{subquery}" : this.getTableName());
    }

    @Override
    public ADQLIterator adqlIterator() {
        return new ADQLIterator(){
            private boolean subQueryGot;
            {
                this.subQueryGot = !ADQLTable.this.isSubQuery();
            }

            @Override
            public ADQLObject next() {
                if (!this.subQueryGot) {
                    this.subQueryGot = true;
                    return ADQLTable.this.subQuery;
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasNext() {
                return !this.subQueryGot;
            }

            @Override
            public void replace(ADQLObject replacer) throws UnsupportedOperationException, IllegalStateException {
                if (!this.subQueryGot) {
                    throw new IllegalStateException("replace(ADQLObject) impossible: next() has not yet been called!");
                }
                if (replacer == null) {
                    this.remove();
                }
                if (!(replacer instanceof ADQLSet)) {
                    throw new UnsupportedOperationException("Impossible to replace a sub-query (" + ADQLTable.this.subQuery.toADQL() + ") by a " + replacer.getClass().getName() + " (" + replacer.toADQL() + ")!");
                }
                ADQLTable.this.subQuery = (ADQLSet)replacer;
            }

            @Override
            public void remove() {
                if (!this.subQueryGot) {
                    throw new IllegalStateException("remove() impossible: next() has not yet been called!");
                }
                throw new UnsupportedOperationException("Impossible to remove the sub-query of an ADQLTable (" + ADQLTable.this.toADQL() + ")!");
            }
        };
    }

    @Override
    public String toADQL() {
        return (this.isSubQuery() ? "(" + this.subQuery.toADQL() + ")" : this.getFullTableName()) + (this.alias == null ? "" : " AS " + (this.isCaseSensitive(IdentifierField.ALIAS) ? "\"" + this.alias + "\"" : this.alias));
    }
}

