/*
 * Copyright (c) 2011, 2018, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package org.graalvm.visualvm.lib.profiler.snaptracer.impl.icons;

import org.graalvm.visualvm.lib.profiler.api.icons.Icons;

/**
 *
 * @author Jiri Sedlacek
 */
public interface TracerIcons extends Icons.Keys {

    public static final String INCREMENT = "TracerIcons.Increment"; // NOI18N
    public static final String DECREMENT = "TracerIcons.Decrement"; // NOI18N
    public static final String RESET = "TracerIcons.Reset"; // NOI18N
    public static final String GENERIC_ACTION = "TracerIcons.GenericAction"; // NOI18N
    public static final String MOUSE_WHEEL_HORIZONTAL = "TracerIcons.MouseWheelHorizontal"; // NOI18N
    public static final String MOUSE_WHEEL_VERTICAL = "TracerIcons.MouseWheelVertical"; // NOI18N
    public static final String MOUSE_WHEEL_ZOOM = "TracerIcons.MouseWheelZoom"; // NOI18N
    public static final String MARK = "TracerIcons.Mark"; // NOI18N
    public static final String MARK_CLEAR = "TracerIcons.MarkClear"; // NOI18N
    public static final String MARK_HIGHLIGHT = "TracerIcons.MarkHiglight"; // NOI18N
    public static final String SELECT_ALL = "TracerIcons.SelectAll"; // NOI18N
    public static final String PROBE = "TracerIcons.Probe"; // NOI18N
    public static final String TRACER = "TracerIcons.Tracer"; // NOI18N
    public static final String TRACER_32 = "TracerIcons.Tracer32"; // NOI18N

}
