/*
 * demo2.x -- demonstrates and tests some jrpcgen features. It doesn't
 *           boil down to a useful example, it just checks a few things
 *           within code generation.
 *
 *           This test tests code generation with a missing program
 *           section, which is now accepted.
 *
 * To compile, use
 *   java -jar jrpcgen.jar -p tests.org.acplt.oncrpc.jrpcgen -nobackup demo-2.x
 */

/* Check that dependencies are followed when dumping constants */
const C_B = C_A;
const C_A = C_C;
const C_C = 42;

/* Check enumerations */
enum ENUMBAZ2 { E_BAZ = C_B };

enum ENUMFOO2 {
    FOO, BAR, BAZ_1 = C_B, BAZ_2, BAZ_3 = E_BAZ
};

struct TREE2 {
	string key<>;
	string value<>;
	struct TREE2 *left;
	struct TREE2 *right;
};

struct INDIRECTIONS2 {
	char *optionalCharacter;
	int *optionalInteger;
	ENUMFOO2 *optionalEnum;
	TREE2 *optionalStruct;
};

struct OPTIONALDATA2 {
	char optionalCharacter<1>;
	int optionalInteger<1>;
	ENUMFOO2 optionalEnum<1>;
	TREE2 optionalStruct<1>;
};

/* Check typedefs */
typedef enum ENUMBAZ2 ENUMBAZ2;
typedef struct TREE2 TREE2;
typedef struct TREE2 SimpleTree;

/**
 * The demo program shall give some examples on
 * type and procedure definitions for ONC/RPC programs.
 *
 * <p>A lot of variants are possible.
 */
program DEMO2 {
    version FIRST_DEMO2_VERSION {
    	/**
    	 * Usually there is no need to define
    	 * the null-procedure call, explicitely.
    	 */
        void NULL(void) = 0;
        
        /**
         * Let's echo the passed string!
         *
         * @param The string to be echoed. 
         * @return The passed string.
         */
        string echo(string) = 1;
        bool checkfoo(ENUMFOO2) = 3;
        ENUMFOO2 foo(void) = 4;
        INDIRECTIONS2 ll(TREE2) = 5;
        OPTIONALDATA2 readSomeResult(void) = 42;
    } = 1;
    version SECOND_DEMO2_VERSION {
        void NULL(void) = 0;
        string cat(string, string) = 42;
        
        /**
         * Concatenates the passed strings.
         *
         * @param one The beginning of the string to build
         * @param two The second part of the string to build
         * @param three The last part of the string to build
         * @return The string resulting from the concatenation of
         * the passed three strings {@code one}, {@code two} and
         * {@code three}.
         */
        string cat3(string one, string two, string three) = 43;
        string checkfoo(ENUMFOO2 foo) = 3;
        OPTIONALDATA2 llcat(TREE2 tree, INDIRECTIONS2 parameters) = 55;
        void test(string a, ENUMFOO2 b, ENUMFOO2 c, PredefinedTypeA d) = 100;
    } = 2;
} = 0x20049679;


/* End of file demo2.x */
